import json

from ksyun.common.exception.ksyun_sdk_exception import KsyunSDKException
from ksyun.common.abstract_client import AbstractClient


class AicpClient(AbstractClient):
    _apiVersion = '2025-12-12'
    _endpoint = 'aicp.api.ksyun.com'
    _service = 'aicp'
    def CreateTrainJob(self, request):
        """创建训练任务
        :param request: Request instance for CreateTrainJob.
        :type request: :class:`ksyun.client.aicp.v20251212.models.CreateTrainJobRequest`
        """
        try:
            params = request._serialize()
            body = self.call_judge("CreateTrainJob", params, "application/json")
            response = json.loads(body)
            if "Error" not in response:
                return body
            else:
                code = response["Error"]["Code"]
                message = response["Error"]["Message"]
                req_id = response["RequestId"]
                raise KsyunSDKException(code, message, req_id)
        except Exception as e:
            if isinstance(e, KsyunSDKException):
                raise
            else:
                raise KsyunSDKException(message=str(e))


    def DescribeTrainJobs(self, request):
        """查询训练任务
        :param request: Request instance for DescribeTrainJobs.
        :type request: :class:`ksyun.client.aicp.v20251212.models.DescribeTrainJobsRequest`
        """
        try:
            params = request._serialize()
            body = self.call_judge("DescribeTrainJobs", params, "application/x-www-form-urlencoded")
            response = json.loads(body)
            if "Error" not in response:
                return body
            else:
                code = response["Error"]["Code"]
                message = response["Error"]["Message"]
                req_id = response["RequestId"]
                raise KsyunSDKException(code, message, req_id)
        except Exception as e:
            if isinstance(e, KsyunSDKException):
                raise
            else:
                raise KsyunSDKException(message=str(e))


