# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: d41e262
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from knowledge_stack.models.chunk_type import ChunkType
from knowledge_stack.models.public_chunk_metadata import PublicChunkMetadata
from knowledge_stack.models.synthetic_chunk_validation_status import SyntheticChunkValidationStatus
from typing import Optional, Set
from typing_extensions import Self

class RespScoredChunk(BaseModel):
    """
    Clean scored chunk response schema.
    """ # noqa: E501
    id: UUID = Field(description="The unique identifier for the chunk")
    chunk_container_id: UUID = Field(description="The ID of the chunk container")
    text: StrictStr = Field(description="The text content of the chunk")
    chunk_type: ChunkType = Field(description="The type of the chunk")
    chunk_metadata: PublicChunkMetadata = Field(description="Context-specific metadata for the chunk")
    chunk_validation_status: SyntheticChunkValidationStatus = Field(description="Validation status of the chunk")
    chunk_validation_details: Optional[Dict[str, Any]] = Field(default=None, description="Validation details of the chunk")
    created_at: datetime = Field(description="The creation timestamp of the chunk")
    updated_at: datetime = Field(description="The last update timestamp of the chunk")
    asset_download_url: Optional[StrictStr] = Field(default=None, description="The presigned URL of the chunk")
    citations: Optional[List[Dict[str, Any]]] = Field(default=None, description="Direct parent citations for this chunk: list of {chunk_id, chunk_container_id, reasoning}")
    score: Union[StrictFloat, StrictInt] = Field(description="The score of the chunk")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "chunk_container_id", "text", "chunk_type", "chunk_metadata", "chunk_validation_status", "chunk_validation_details", "created_at", "updated_at", "asset_download_url", "citations", "score"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespScoredChunk from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chunk_metadata
        if self.chunk_metadata:
            _dict['chunk_metadata'] = self.chunk_metadata.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespScoredChunk from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "chunk_container_id": obj.get("chunk_container_id"),
            "text": obj.get("text"),
            "chunk_type": obj.get("chunk_type"),
            "chunk_metadata": PublicChunkMetadata.from_dict(obj["chunk_metadata"]) if obj.get("chunk_metadata") is not None else None,
            "chunk_validation_status": obj.get("chunk_validation_status"),
            "chunk_validation_details": obj.get("chunk_validation_details"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "asset_download_url": obj.get("asset_download_url"),
            "citations": obj.get("citations"),
            "score": obj.get("score")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


