# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: d3ded15
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ReqCreateAgentParticipant(BaseModel):
    """
    Request schema for creating an agent participant.
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the participant")
    description: Optional[StrictStr] = Field(default=None, description="The description of the participant")
    url: StrictStr = Field(description="The URL of the agent")
    api_key: StrictStr = Field(description="The API key of the agent")
    read_only_paths: Optional[List[StrictStr]] = Field(default=None, description="Paths that the participant can read from")
    read_write_paths: Optional[List[StrictStr]] = Field(default=None, description="Paths that the participant can read from and write to")
    __properties: ClassVar[List[str]] = ["name", "description", "url", "api_key", "read_only_paths", "read_write_paths"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReqCreateAgentParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReqCreateAgentParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "api_key": obj.get("api_key"),
            "read_only_paths": obj.get("read_only_paths"),
            "read_write_paths": obj.get("read_write_paths")
        })
        return _obj


