# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: d3ded15
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.chunk_type import ChunkType
from typing import Optional, Set
from typing_extensions import Self

class RespTurnChunk(BaseModel):
    """
    RespTurnChunk
    """ # noqa: E501
    chunk_id: UUID = Field(description="The ID of the chunk")
    chunk_container_id: UUID = Field(description="The ID of the chunk container")
    chunk_type: ChunkType = Field(description="The type of the chunk")
    chunk_text: StrictStr = Field(description="The content of the chunk")
    created_at: datetime = Field(description="The timestamp of the chunk")
    updated_at: datetime = Field(description="The timestamp of the chunk")
    asset_download_url: Optional[StrictStr] = Field(default=None, description="The URL of the asset")
    citations: Optional[List[Dict[str, Any]]] = Field(default=None, description="Direct parent citations for this chunk: list of {chunk_id, chunk_container_id, reasoning}")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["chunk_id", "chunk_container_id", "chunk_type", "chunk_text", "created_at", "updated_at", "asset_download_url", "citations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespTurnChunk from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespTurnChunk from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chunk_id": obj.get("chunk_id"),
            "chunk_container_id": obj.get("chunk_container_id"),
            "chunk_type": obj.get("chunk_type"),
            "chunk_text": obj.get("chunk_text"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "asset_download_url": obj.get("asset_download_url"),
            "citations": obj.get("citations")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


