# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: a9f7a94
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class PublicChunkMetadata(BaseModel):
    """
    Chunk metadata for use in the public API.
    """ # noqa: E501
    polygon: Optional[Dict[str, List[Annotated[List[Any], Field(min_length=2, max_length=2)]]]] = Field(default=None, description="The bounding polygons of the chunk. If box, the list should have exactly 4 points.")
    section_name: Optional[StrictStr] = Field(default=None, description="The closest hierarchy this chunk belongs to")
    page_start: Optional[StrictInt] = Field(default=0, description="The page number of the first page of the chunk")
    page_end: Optional[StrictInt] = Field(default=0, description="The page number of the last page of the chunk")
    hierarchy_level: Optional[StrictInt] = Field(default=0, description="The level of the chunk's hierarchy")
    hierarchy_path: Optional[StrictStr] = Field(default='', description="The chunk's hierarchy in slash notation")
    title: Optional[StrictStr] = Field(default=None, description="The title of the chunk")
    category: Optional[StrictStr] = Field(default=None, description="The category of the table/image")
    sequence_number: Optional[StrictInt] = Field(default=-1, description="The sequence number of the chunk")
    prev_chunk_id: Optional[UUID] = Field(default=None, description="The ID of the previous chunk")
    next_chunk_id: Optional[UUID] = Field(default=None, description="The ID of the next chunk")
    folder_uuid_path_array: Optional[List[UUID]] = Field(default=None, description="Folder UUID path from root to current folder")
    __properties: ClassVar[List[str]] = ["polygon", "section_name", "page_start", "page_end", "hierarchy_level", "hierarchy_path", "title", "category", "sequence_number", "prev_chunk_id", "next_chunk_id", "folder_uuid_path_array"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicChunkMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicChunkMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "polygon": obj.get("polygon"),
            "section_name": obj.get("section_name"),
            "page_start": obj.get("page_start") if obj.get("page_start") is not None else 0,
            "page_end": obj.get("page_end") if obj.get("page_end") is not None else 0,
            "hierarchy_level": obj.get("hierarchy_level") if obj.get("hierarchy_level") is not None else 0,
            "hierarchy_path": obj.get("hierarchy_path") if obj.get("hierarchy_path") is not None else '',
            "title": obj.get("title"),
            "category": obj.get("category"),
            "sequence_number": obj.get("sequence_number") if obj.get("sequence_number") is not None else -1,
            "prev_chunk_id": obj.get("prev_chunk_id"),
            "next_chunk_id": obj.get("next_chunk_id"),
            "folder_uuid_path_array": obj.get("folder_uuid_path_array")
        })
        return _obj


