# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: eef51b1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.req_search_chunks import ReqSearchChunks
from knowledge_stack.models.resp_scored_chunk import RespScoredChunk

from knowledge_stack.api_client import ApiClient, RequestSerialized
from knowledge_stack.api_response import ApiResponse
from knowledge_stack.rest import RESTResponseType


class SearchApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def search_chunks(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        req_search_chunks: ReqSearchChunks,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        storage_engine_name: Annotated[Optional[StrictStr], Field(description="The name of the search engine to use")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RespScoredChunk]:
        """Search chunks

        Query documents in the vector database using semantic search.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param req_search_chunks: (required)
        :type req_search_chunks: ReqSearchChunks
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param storage_engine_name: The name of the search engine to use
        :type storage_engine_name: str
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_chunks_serialize(
            tenant_id=tenant_id,
            req_search_chunks=req_search_chunks,
            asset_download_url_expiration=asset_download_url_expiration,
            storage_engine_name=storage_engine_name,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RespScoredChunk]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_chunks_with_http_info(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        req_search_chunks: ReqSearchChunks,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        storage_engine_name: Annotated[Optional[StrictStr], Field(description="The name of the search engine to use")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RespScoredChunk]]:
        """Search chunks

        Query documents in the vector database using semantic search.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param req_search_chunks: (required)
        :type req_search_chunks: ReqSearchChunks
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param storage_engine_name: The name of the search engine to use
        :type storage_engine_name: str
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_chunks_serialize(
            tenant_id=tenant_id,
            req_search_chunks=req_search_chunks,
            asset_download_url_expiration=asset_download_url_expiration,
            storage_engine_name=storage_engine_name,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RespScoredChunk]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_chunks_without_preload_content(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        req_search_chunks: ReqSearchChunks,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        storage_engine_name: Annotated[Optional[StrictStr], Field(description="The name of the search engine to use")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search chunks

        Query documents in the vector database using semantic search.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param req_search_chunks: (required)
        :type req_search_chunks: ReqSearchChunks
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param storage_engine_name: The name of the search engine to use
        :type storage_engine_name: str
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_chunks_serialize(
            tenant_id=tenant_id,
            req_search_chunks=req_search_chunks,
            asset_download_url_expiration=asset_download_url_expiration,
            storage_engine_name=storage_engine_name,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RespScoredChunk]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_chunks_serialize(
        self,
        tenant_id,
        req_search_chunks,
        asset_download_url_expiration,
        storage_engine_name,
        ks_uat,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenant_id'] = tenant_id
        # process the query parameters
        if asset_download_url_expiration is not None:
            
            _query_params.append(('asset_download_url_expiration', asset_download_url_expiration))
            
        if storage_engine_name is not None:
            
            _query_params.append(('storage_engine_name', storage_engine_name))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if req_search_chunks is not None:
            _body_params = req_search_chunks


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/tenant/{tenant_id}/search/chunks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


