# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: eef51b1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from knowledge_stack.models.resp_tenant import RespTenant
from typing import Optional, Set
from typing_extensions import Self

class PaginatedResponseRespTenant(BaseModel):
    """
    PaginatedResponseRespTenant
    """ # noqa: E501
    items: List[RespTenant] = Field(description="List of items")
    total: Annotated[int, Field(strict=True, ge=0)] = Field(description="Total number of items")
    limit: Annotated[int, Field(strict=True, ge=1)] = Field(description="Max. number of items to fetch")
    offset: Annotated[int, Field(strict=True, ge=0)] = Field(description="Number of items to skip")
    __properties: ClassVar[List[str]] = ["items", "total", "limit", "offset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaginatedResponseRespTenant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaginatedResponseRespTenant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "items": [RespTenant.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "total": obj.get("total"),
            "limit": obj.get("limit"),
            "offset": obj.get("offset")
        })
        return _obj


