# knowledge-stack
Public-facing API for external access

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 03723a4
- Package version: 0.2.3
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import knowledge_stack
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import knowledge_stack
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import knowledge_stack
from knowledge_stack.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8000
# See configuration.py for a list of all supported configuration parameters.
configuration = knowledge_stack.Configuration(
    host = "http://localhost:8000"
)



# Enter a context with an instance of the API client
with knowledge_stack.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = knowledge_stack.AdminApi(api_client)
    req_organization_create = knowledge_stack.ReqOrganizationCreate() # ReqOrganizationCreate | 
    authorization = 'authorization_example' # str |  (optional)
    ks_uat = 'ks_uat_example' # str |  (optional)

    try:
        # Create a new organization
        api_response = api_instance.create_organization(req_organization_create, authorization=authorization, ks_uat=ks_uat)
        print("The response of AdminApi->create_organization:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminApi->create_organization: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**create_organization**](docs/AdminApi.md#create_organization) | **POST** /api/v1/admin/organizations | Create a new organization
*AdminApi* | [**delete_organization**](docs/AdminApi.md#delete_organization) | **DELETE** /api/v1/admin/organizations/{organization_id} | Delete organization
*AdminApi* | [**get_organization_by_id**](docs/AdminApi.md#get_organization_by_id) | **GET** /api/v1/admin/organizations/{organization_id} | Get organization by ID
*AdminApi* | [**list_organizations**](docs/AdminApi.md#list_organizations) | **GET** /api/v1/admin/organizations | List organizations
*AdminApi* | [**restore_organization**](docs/AdminApi.md#restore_organization) | **POST** /api/v1/admin/organizations/{organization_id}/restore | Restore organization
*AdminApi* | [**update_organization**](docs/AdminApi.md#update_organization) | **PUT** /api/v1/admin/organizations/{organization_id} | Update organization
*AgentParticipantsApi* | [**create_agent_participant**](docs/AgentParticipantsApi.md#create_agent_participant) | **POST** /api/v1/tenant/{tenant_id}/agents | Create Agent Participant
*AgentParticipantsApi* | [**delete_agent_participant**](docs/AgentParticipantsApi.md#delete_agent_participant) | **DELETE** /api/v1/tenant/{tenant_id}/agents/{participant_id} | Delete Agent Participant Handler
*AgentParticipantsApi* | [**get_agent_participant**](docs/AgentParticipantsApi.md#get_agent_participant) | **GET** /api/v1/tenant/{tenant_id}/agents/{participant_id} | Get Agent Participant Handler
*AgentParticipantsApi* | [**list_agent_participants**](docs/AgentParticipantsApi.md#list_agent_participants) | **GET** /api/v1/tenant/{tenant_id}/agents | List Agent Participants Handler
*AgentParticipantsApi* | [**update_agent_participant**](docs/AgentParticipantsApi.md#update_agent_participant) | **PATCH** /api/v1/tenant/{tenant_id}/agents/{participant_id} | Update Agent Participant Handler
*AuthApi* | [**accept_invite**](docs/AuthApi.md#accept_invite) | **POST** /api/v1/auth/invite/accept | Invite Handler
*AuthApi* | [**auth_callback_api_v1_auth_oauth_callback_get**](docs/AuthApi.md#auth_callback_api_v1_auth_oauth_callback_get) | **GET** /api/v1/auth/oauth/callback | KS IdP OAuth callback
*AuthApi* | [**check_identity_api_v1_auth_check_identity_get**](docs/AuthApi.md#check_identity_api_v1_auth_check_identity_get) | **GET** /api/v1/auth/check-identity | Check identity
*AuthApi* | [**create_ksidp_pw_user**](docs/AuthApi.md#create_ksidp_pw_user) | **POST** /api/v1/auth/ksidp/user/v2/create_pw_user | Create Ksidp Pw User Handler
*AuthApi* | [**create_ksidp_pw_user_and_tenant**](docs/AuthApi.md#create_ksidp_pw_user_and_tenant) | **POST** /api/v1/auth/ksidp/user/create_pw_and_tenant | Create Ksidp Pw User And Tenant Handler
*AuthApi* | [**exchange_identity_token_for_user_access_token**](docs/AuthApi.md#exchange_identity_token_for_user_access_token) | **POST** /api/v1/auth/token/uat | Exchange identity token for user access token
*AuthApi* | [**get_access_token_identity**](docs/AuthApi.md#get_access_token_identity) | **GET** /api/v1/auth/token/access | Get access token identity
*AuthApi* | [**get_ks_thread_token_identity**](docs/AuthApi.md#get_ks_thread_token_identity) | **GET** /api/v1/auth/token/thread | Get thread token identity
*AuthApi* | [**initiate_ksidp_flow**](docs/AuthApi.md#initiate_ksidp_flow) | **POST** /api/v1/auth/idp/ks/initiate | Initiate KS IdP flow
*AuthApi* | [**ksidp_oauth_callback_v2**](docs/AuthApi.md#ksidp_oauth_callback_v2) | **GET** /api/v1/auth/oauth/callback/v2 | KS IdP OAuth callback v2
*AuthApi* | [**ksidp_pw_user_signin**](docs/AuthApi.md#ksidp_pw_user_signin) | **POST** /api/v1/auth/ksidp/user/signin | Ksidp Pw User Signin Handler
*AuthApi* | [**ksidp_pw_user_signin_v2**](docs/AuthApi.md#ksidp_pw_user_signin_v2) | **POST** /api/v1/auth/ksidp/user/v2/signin | Ksidp Pw User Signin Handler
*AuthApi* | [**logout**](docs/AuthApi.md#logout) | **POST** /api/v1/auth/logout | Logout Handler
*AuthApi* | [**refresh_ks_thread_token**](docs/AuthApi.md#refresh_ks_thread_token) | **POST** /api/v1/auth/token/thread/refresh | Refresh thread token
*ChunksApi* | [**get_chunk_content**](docs/ChunksApi.md#get_chunk_content) | **GET** /api/v1/tenant/{tenant_id}/chunks/{chunk_id} | Get Chunk
*ChunksApi* | [**get_chunk_lineage**](docs/ChunksApi.md#get_chunk_lineage) | **GET** /api/v1/tenant/{tenant_id}/chunks/{chunk_id}/lineage | Get chunk lineage
*ChunksApi* | [**list_chunks**](docs/ChunksApi.md#list_chunks) | **GET** /api/v1/tenant/{tenant_id}/chunks | List Chunks
*ChunksApi* | [**update_chunk_validation**](docs/ChunksApi.md#update_chunk_validation) | **PUT** /api/v1/tenant/{tenant_id}/chunks/{chunk_id}/validation | Update Chunk Validation
*DocumentTagsApi* | [**list_document_tags**](docs/DocumentTagsApi.md#list_document_tags) | **GET** /api/v1/tenant/{tenant_id}/documents/{document_id}/tags | List Document Tags Endpoint
*DocumentTagsApi* | [**update_document_tags**](docs/DocumentTagsApi.md#update_document_tags) | **PUT** /api/v1/tenant/{tenant_id}/documents/{document_id}/tags | Update Document Tags Endpoint
*DocumentsApi* | [**create_document_version**](docs/DocumentsApi.md#create_document_version) | **POST** /api/v1/tenant/{tenant_id}/document_versions | Create Document Version for a given document ID
*DocumentsApi* | [**delete_document**](docs/DocumentsApi.md#delete_document) | **DELETE** /api/v1/tenant/{tenant_id}/documents/{document_id} | Delete Document by ID
*DocumentsApi* | [**get_document_by_id**](docs/DocumentsApi.md#get_document_by_id) | **GET** /api/v1/tenant/{tenant_id}/documents/{document_id} | Get Document by ID
*DocumentsApi* | [**get_document_version**](docs/DocumentsApi.md#get_document_version) | **GET** /api/v1/tenant/{tenant_id}/document_versions/{document_version_id} | Get Document Version by document version ID
*DocumentsApi* | [**ingest_document**](docs/DocumentsApi.md#ingest_document) | **POST** /api/v1/tenant/{tenant_id}/folders/{folder_id}/documents/ingest | Create Document
*DocumentsApi* | [**list_document_versions**](docs/DocumentsApi.md#list_document_versions) | **GET** /api/v1/tenant/{tenant_id}/document_versions | List Document Versions for a given document ID
*DocumentsApi* | [**list_documents**](docs/DocumentsApi.md#list_documents) | **GET** /api/v1/tenant/{tenant_id}/documents | List Documents
*DocumentsApi* | [**move_document**](docs/DocumentsApi.md#move_document) | **PATCH** /api/v1/tenant/{tenant_id}/documents/{document_id}/folder | Move Document to Different Folder
*DocumentsApi* | [**restore_document**](docs/DocumentsApi.md#restore_document) | **POST** /api/v1/tenant/{tenant_id}/documents/{document_id}/restore | Restore Document by ID
*DocumentsApi* | [**update_document**](docs/DocumentsApi.md#update_document) | **PATCH** /api/v1/tenant/{tenant_id}/documents/{document_id} | Update Document by ID
*FolderTagsApi* | [**list_folder_tags**](docs/FolderTagsApi.md#list_folder_tags) | **GET** /api/v1/tenant/{tenant_id}/folders/{folder_id}/tags | List Folder Tags Endpoint
*FolderTagsApi* | [**update_folder_tags**](docs/FolderTagsApi.md#update_folder_tags) | **PUT** /api/v1/tenant/{tenant_id}/folders/{folder_id}/tags | Update Folder Tags Endpoint
*FoldersApi* | [**create_folder**](docs/FoldersApi.md#create_folder) | **POST** /api/v1/tenant/{tenant_id}/folders | Create Folder Endpoint
*FoldersApi* | [**delete_folder**](docs/FoldersApi.md#delete_folder) | **DELETE** /api/v1/tenant/{tenant_id}/folders/{folder_id} | Delete Folder
*FoldersApi* | [**get_folder**](docs/FoldersApi.md#get_folder) | **GET** /api/v1/tenant/{tenant_id}/folders/{folder_id} | Get Folder Endpoint
*FoldersApi* | [**list_folder_contents**](docs/FoldersApi.md#list_folder_contents) | **GET** /api/v1/tenant/{tenant_id}/folders/contents | List Folder Contents Endpoint
*FoldersApi* | [**move_folder**](docs/FoldersApi.md#move_folder) | **PATCH** /api/v1/tenant/{tenant_id}/folders/{folder_id}/move | Move Folder Endpoint
*FoldersApi* | [**rename_folder**](docs/FoldersApi.md#rename_folder) | **PATCH** /api/v1/tenant/{tenant_id}/folders/{folder_id}/rename | Rename Folder Endpoint
*FoldersApi* | [**restore_folder**](docs/FoldersApi.md#restore_folder) | **POST** /api/v1/tenant/{tenant_id}/folders/{folder_id}/restore | Restore Folder
*FoldersApi* | [**update_folder_metadata**](docs/FoldersApi.md#update_folder_metadata) | **PATCH** /api/v1/tenant/{tenant_id}/folders/{folder_id}/metadata | Update Folder Metadata Endpoint
*InviteApi* | [**create_or_get_active_invite**](docs/InviteApi.md#create_or_get_active_invite) | **POST** /api/v1/tenant/{tenant_id}/invite | Create or get active invite
*InviteApi* | [**delete_invite**](docs/InviteApi.md#delete_invite) | **DELETE** /api/v1/tenant/{tenant_id}/invite/{invite_id} | Delete Invite
*InviteApi* | [**get_tenant_invite**](docs/InviteApi.md#get_tenant_invite) | **GET** /api/v1/tenant/{tenant_id}/invite/{invite_id} | Get Invite
*InviteApi* | [**list_invites**](docs/InviteApi.md#list_invites) | **GET** /api/v1/tenant/{tenant_id}/invite | List Invites
*JobsApi* | [**get_job**](docs/JobsApi.md#get_job) | **GET** /api/v1/tenant/{tenant_id}/jobs/{job_id} | Get Job details
*JobsApi* | [**list_jobs**](docs/JobsApi.md#list_jobs) | **GET** /api/v1/tenant/{tenant_id}/jobs | List Jobs
*OAuthCallbackApi* | [**auth_callback_api_v1_auth_oauth_callback_get**](docs/OAuthCallbackApi.md#auth_callback_api_v1_auth_oauth_callback_get) | **GET** /api/v1/auth/oauth/callback | KS IdP OAuth callback
*OAuthCallbackApi* | [**ksidp_oauth_callback_v2**](docs/OAuthCallbackApi.md#ksidp_oauth_callback_v2) | **GET** /api/v1/auth/oauth/callback/v2 | KS IdP OAuth callback v2
*OrganizationApi* | [**create_tenant**](docs/OrganizationApi.md#create_tenant) | **POST** /api/v1/organization/{organization_id}/tenants | Create a new tenant under the given organization
*OrganizationApi* | [**delete_tenant_by_id**](docs/OrganizationApi.md#delete_tenant_by_id) | **DELETE** /api/v1/organization/{organization_id}/tenants/{tenant_id} | Delete tenant
*OrganizationApi* | [**list_tenants**](docs/OrganizationApi.md#list_tenants) | **GET** /api/v1/organization/{organization_id}/tenants | List tenants with optional filtering
*OrganizationApi* | [**restore_tenant_by_id**](docs/OrganizationApi.md#restore_tenant_by_id) | **POST** /api/v1/organization/{organization_id}/tenants/{tenant_id}/restore | Restore tenant
*QueryApi* | [**ask**](docs/QueryApi.md#ask) | **POST** /api/v1/tenant/{tenant_id}/query/ask | DEPRECATED: Use the new search endpoint instead
*SearchApi* | [**search_chunks**](docs/SearchApi.md#search_chunks) | **POST** /api/v1/tenant/{tenant_id}/search/chunks | Search chunks
*TenantTagsApi* | [**create_tag**](docs/TenantTagsApi.md#create_tag) | **POST** /api/v1/tenant/{tenant_id}/tags | Create a new tenant tag
*TenantTagsApi* | [**delete_tag**](docs/TenantTagsApi.md#delete_tag) | **DELETE** /api/v1/tenant/{tenant_id}/tags/{tag_id} | Delete tenant tag
*TenantTagsApi* | [**get_tag**](docs/TenantTagsApi.md#get_tag) | **GET** /api/v1/tenant/{tenant_id}/tags/{tag_id} | Get tenant tag by ID
*TenantTagsApi* | [**list_tags**](docs/TenantTagsApi.md#list_tags) | **GET** /api/v1/tenant/{tenant_id}/tags | List tenant tags
*TenantTagsApi* | [**restore_tag**](docs/TenantTagsApi.md#restore_tag) | **POST** /api/v1/tenant/{tenant_id}/tags/{tag_id}/restore | Restore tenant tag
*TenantTagsApi* | [**update_tag**](docs/TenantTagsApi.md#update_tag) | **PUT** /api/v1/tenant/{tenant_id}/tags/{tag_id} | Update tenant tag
*TenantThreadsApi* | [**add_thread_participants**](docs/TenantThreadsApi.md#add_thread_participants) | **POST** /api/v1/tenant/{tenant_id}/threads/{thread_id}/participants | Add participants to a thread
*TenantThreadsApi* | [**add_thread_participants_0**](docs/TenantThreadsApi.md#add_thread_participants_0) | **POST** /api/v1/tenant/{tenant_id}/threads/{thread_id}/participants | Add participants to a thread
*TenantThreadsApi* | [**create_thread**](docs/TenantThreadsApi.md#create_thread) | **POST** /api/v1/tenant/{tenant_id}/threads | Create a new tenant thread
*TenantThreadsApi* | [**delete_thread**](docs/TenantThreadsApi.md#delete_thread) | **DELETE** /api/v1/tenant/{tenant_id}/threads/{thread_id} | Delete a thread
*TenantThreadsApi* | [**get_thread**](docs/TenantThreadsApi.md#get_thread) | **GET** /api/v1/tenant/{tenant_id}/threads/{thread_id} | Get thread by ID
*TenantThreadsApi* | [**list_thread_participants**](docs/TenantThreadsApi.md#list_thread_participants) | **GET** /api/v1/tenant/{tenant_id}/threads/{thread_id}/participants | List participants in a thread
*TenantThreadsApi* | [**list_thread_participants_0**](docs/TenantThreadsApi.md#list_thread_participants_0) | **GET** /api/v1/tenant/{tenant_id}/threads/{thread_id}/participants | List participants in a thread
*TenantThreadsApi* | [**list_threads**](docs/TenantThreadsApi.md#list_threads) | **GET** /api/v1/tenant/{tenant_id}/threads | List threads
*TenantThreadsApi* | [**remove_thread_participant**](docs/TenantThreadsApi.md#remove_thread_participant) | **DELETE** /api/v1/tenant/{tenant_id}/threads/{thread_id}/participants/{participant_id} | Remove a participant from a thread
*TenantThreadsApi* | [**remove_thread_participant_0**](docs/TenantThreadsApi.md#remove_thread_participant_0) | **DELETE** /api/v1/tenant/{tenant_id}/threads/{thread_id}/participants/{participant_id} | Remove a participant from a thread
*ThreadTurnsApi* | [**create_thread_turn**](docs/ThreadTurnsApi.md#create_thread_turn) | **POST** /api/v1/tenant/{tenant_id}/threads/{thread_id}/turns | Create a single turn
*ThreadTurnsApi* | [**create_thread_turns_bulk**](docs/ThreadTurnsApi.md#create_thread_turns_bulk) | **POST** /api/v1/tenant/{tenant_id}/threads/{thread_id}/turns/bulk | Create turns in bulk
*ThreadTurnsApi* | [**list_thread_turns_public**](docs/ThreadTurnsApi.md#list_thread_turns_public) | **GET** /api/v1/tenant/{tenant_id}/threads/{thread_id}/turns | List thread turns
*UserParticipantsApi* | [**create_user_participant**](docs/UserParticipantsApi.md#create_user_participant) | **POST** /api/v1/tenant/{tenant_id}/users | Create User Participant
*UserParticipantsApi* | [**delete_user_participant**](docs/UserParticipantsApi.md#delete_user_participant) | **DELETE** /api/v1/tenant/{tenant_id}/users/{participant_id} | Delete User Participant Handler
*UserParticipantsApi* | [**get_user_participant**](docs/UserParticipantsApi.md#get_user_participant) | **GET** /api/v1/tenant/{tenant_id}/users/{participant_id} | Get User Participant Handler
*UserParticipantsApi* | [**list_user_participants**](docs/UserParticipantsApi.md#list_user_participants) | **GET** /api/v1/tenant/{tenant_id}/users | List User Participants Handler
*UserParticipantsApi* | [**update_user_participant**](docs/UserParticipantsApi.md#update_user_participant) | **PATCH** /api/v1/tenant/{tenant_id}/users/{participant_id} | Update User Participant Handler
*DefaultApi* | [**get_tenant_by_id**](docs/DefaultApi.md#get_tenant_by_id) | **GET** /api/v1/tenant/{tenant_id} | Get tenant by ID
*DefaultApi* | [**update_tenant_by_id**](docs/DefaultApi.md#update_tenant_by_id) | **PUT** /api/v1/tenant/{tenant_id} | Update tenant


## Documentation For Models

 - [APIKeyCredentialType](docs/APIKeyCredentialType.md)
 - [AccessTokenType](docs/AccessTokenType.md)
 - [AuthenticationType](docs/AuthenticationType.md)
 - [BaseRespDelete](docs/BaseRespDelete.md)
 - [Category](docs/Category.md)
 - [ChunkType](docs/ChunkType.md)
 - [CitationItem](docs/CitationItem.md)
 - [DocumentProcessingStatus](docs/DocumentProcessingStatus.md)
 - [DocumentVersionMetadata](docs/DocumentVersionMetadata.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ImageCategory](docs/ImageCategory.md)
 - [InviteStatus](docs/InviteStatus.md)
 - [JobStatusInput](docs/JobStatusInput.md)
 - [JobStatusOutput](docs/JobStatusOutput.md)
 - [JobType](docs/JobType.md)
 - [KSAuthProviderType](docs/KSAuthProviderType.md)
 - [KsidpPWUserCreateRequest](docs/KsidpPWUserCreateRequest.md)
 - [KsidpPWUserSigninRequest](docs/KsidpPWUserSigninRequest.md)
 - [ListFolderContentType](docs/ListFolderContentType.md)
 - [PaginatedResponseRespChunk](docs/PaginatedResponseRespChunk.md)
 - [PaginatedResponseRespCompleteTag](docs/PaginatedResponseRespCompleteTag.md)
 - [PaginatedResponseRespDocument](docs/PaginatedResponseRespDocument.md)
 - [PaginatedResponseRespDocumentTag](docs/PaginatedResponseRespDocumentTag.md)
 - [PaginatedResponseRespDocumentVersion](docs/PaginatedResponseRespDocumentVersion.md)
 - [PaginatedResponseRespInvite](docs/PaginatedResponseRespInvite.md)
 - [PaginatedResponseRespJob](docs/PaginatedResponseRespJob.md)
 - [PaginatedResponseRespOrganization](docs/PaginatedResponseRespOrganization.md)
 - [PaginatedResponseRespParticipant](docs/PaginatedResponseRespParticipant.md)
 - [PaginatedResponseRespTenant](docs/PaginatedResponseRespTenant.md)
 - [PaginatedResponseRespThread](docs/PaginatedResponseRespThread.md)
 - [PaginatedResponseRespThreadParticipant](docs/PaginatedResponseRespThreadParticipant.md)
 - [PaginatedResponseRespThreadTurn](docs/PaginatedResponseRespThreadTurn.md)
 - [PaginatedResponseRespThreadTurnBasic](docs/PaginatedResponseRespThreadTurnBasic.md)
 - [ParticipantType](docs/ParticipantType.md)
 - [ProcessingStage](docs/ProcessingStage.md)
 - [PublicApiSchemasResponsesParticipantRespParticipant](docs/PublicApiSchemasResponsesParticipantRespParticipant.md)
 - [PublicApiSchemasResponsesThreadsRespParticipant](docs/PublicApiSchemasResponsesThreadsRespParticipant.md)
 - [PublicChunkMetadata](docs/PublicChunkMetadata.md)
 - [ReqCreateAgentParticipant](docs/ReqCreateAgentParticipant.md)
 - [ReqCreateFolder](docs/ReqCreateFolder.md)
 - [ReqCreateInvite](docs/ReqCreateInvite.md)
 - [ReqCreateUserParticipant](docs/ReqCreateUserParticipant.md)
 - [ReqMoveFolder](docs/ReqMoveFolder.md)
 - [ReqOrganizationCreate](docs/ReqOrganizationCreate.md)
 - [ReqOrganizationUpdate](docs/ReqOrganizationUpdate.md)
 - [ReqRenameFolder](docs/ReqRenameFolder.md)
 - [ReqSearchChunks](docs/ReqSearchChunks.md)
 - [ReqTagCreate](docs/ReqTagCreate.md)
 - [ReqTagUpdate](docs/ReqTagUpdate.md)
 - [ReqTenantCreate](docs/ReqTenantCreate.md)
 - [ReqTenantUpdate](docs/ReqTenantUpdate.md)
 - [ReqThreadCreate](docs/ReqThreadCreate.md)
 - [ReqThreadParticipantAdd](docs/ReqThreadParticipantAdd.md)
 - [ReqTurnsBulkCreate](docs/ReqTurnsBulkCreate.md)
 - [ReqUpdateAgentParticipant](docs/ReqUpdateAgentParticipant.md)
 - [ReqUpdateChunkValidation](docs/ReqUpdateChunkValidation.md)
 - [ReqUpdateDocument](docs/ReqUpdateDocument.md)
 - [ReqUpdateDocumentTags](docs/ReqUpdateDocumentTags.md)
 - [ReqUpdateFolderMetadata](docs/ReqUpdateFolderMetadata.md)
 - [ReqUpdateFolderTags](docs/ReqUpdateFolderTags.md)
 - [ReqUpdateUserParticipant](docs/ReqUpdateUserParticipant.md)
 - [ResolvedIdentity](docs/ResolvedIdentity.md)
 - [ResourceType](docs/ResourceType.md)
 - [RespAcceptInvite](docs/RespAcceptInvite.md)
 - [RespAsyncIngest](docs/RespAsyncIngest.md)
 - [RespBulkDocumentTagOperation](docs/RespBulkDocumentTagOperation.md)
 - [RespBulkFolderTagOperation](docs/RespBulkFolderTagOperation.md)
 - [RespChunk](docs/RespChunk.md)
 - [RespChunkLineage](docs/RespChunkLineage.md)
 - [RespChunkLineageEdge](docs/RespChunkLineageEdge.md)
 - [RespCompleteTag](docs/RespCompleteTag.md)
 - [RespDocument](docs/RespDocument.md)
 - [RespDocumentDelete](docs/RespDocumentDelete.md)
 - [RespDocumentMove](docs/RespDocumentMove.md)
 - [RespDocumentRestore](docs/RespDocumentRestore.md)
 - [RespDocumentSummary](docs/RespDocumentSummary.md)
 - [RespDocumentTag](docs/RespDocumentTag.md)
 - [RespDocumentVersion](docs/RespDocumentVersion.md)
 - [RespFolder](docs/RespFolder.md)
 - [RespFolderContents](docs/RespFolderContents.md)
 - [RespFolderDelete](docs/RespFolderDelete.md)
 - [RespFolderRestore](docs/RespFolderRestore.md)
 - [RespGetAccessTokenIdentity](docs/RespGetAccessTokenIdentity.md)
 - [RespGetKSThreadTokenIdentity](docs/RespGetKSThreadTokenIdentity.md)
 - [RespIdPRedirect](docs/RespIdPRedirect.md)
 - [RespInvite](docs/RespInvite.md)
 - [RespJob](docs/RespJob.md)
 - [RespOrganization](docs/RespOrganization.md)
 - [RespOrganizationCreate](docs/RespOrganizationCreate.md)
 - [RespRefreshKSThreadToken](docs/RespRefreshKSThreadToken.md)
 - [RespScoredChunk](docs/RespScoredChunk.md)
 - [RespTag](docs/RespTag.md)
 - [RespTagCreate](docs/RespTagCreate.md)
 - [RespTagDelete](docs/RespTagDelete.md)
 - [RespTenant](docs/RespTenant.md)
 - [RespTenantCreate](docs/RespTenantCreate.md)
 - [RespTenantDelete](docs/RespTenantDelete.md)
 - [RespThread](docs/RespThread.md)
 - [RespThreadCreate](docs/RespThreadCreate.md)
 - [RespThreadParticipant](docs/RespThreadParticipant.md)
 - [RespThreadTurn](docs/RespThreadTurn.md)
 - [RespThreadTurnBasic](docs/RespThreadTurnBasic.md)
 - [RespTurnChunk](docs/RespTurnChunk.md)
 - [RespUserSignIn](docs/RespUserSignIn.md)
 - [RespUserSignInV2](docs/RespUserSignInV2.md)
 - [SyntheticChunkValidationStatus](docs/SyntheticChunkValidationStatus.md)
 - [TableCategory](docs/TableCategory.md)
 - [TagSourceInput](docs/TagSourceInput.md)
 - [TagSourceOutput](docs/TagSourceOutput.md)
 - [TenantIdpType](docs/TenantIdpType.md)
 - [TenantParticipantRole](docs/TenantParticipantRole.md)
 - [TurnAssetItem](docs/TurnAssetItem.md)
 - [TurnItem](docs/TurnItem.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication


## Author




