# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 699f5df
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.public_api_schemas_responses_threads_resp_participant import PublicApiSchemasResponsesThreadsRespParticipant
from knowledge_stack.models.resp_turn_chunk import RespTurnChunk
from typing import Optional, Set
from typing_extensions import Self

class RespThreadTurn(BaseModel):
    """
    RespThreadTurn
    """ # noqa: E501
    turn_id: UUID = Field(description="The ID of the turn")
    participant: PublicApiSchemasResponsesThreadsRespParticipant = Field(description="The participant of the turn")
    turn_number: StrictInt = Field(description="The number of the turn")
    chunks: Optional[List[RespTurnChunk]] = Field(default=None, description="The chunks in the turn")
    created_at: datetime = Field(description="The timestamp of the turn")
    __properties: ClassVar[List[str]] = ["turn_id", "participant", "turn_number", "chunks", "created_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespThreadTurn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in chunks (list)
        _items = []
        if self.chunks:
            for _item_chunks in self.chunks:
                if _item_chunks:
                    _items.append(_item_chunks.to_dict())
            _dict['chunks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespThreadTurn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "turn_id": obj.get("turn_id"),
            "participant": PublicApiSchemasResponsesThreadsRespParticipant.from_dict(obj["participant"]) if obj.get("participant") is not None else None,
            "turn_number": obj.get("turn_number"),
            "chunks": [RespTurnChunk.from_dict(_item) for _item in obj["chunks"]] if obj.get("chunks") is not None else None,
            "created_at": obj.get("created_at")
        })
        return _obj


