# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 8e3cf7e
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.authentication_type import AuthenticationType
from knowledge_stack.models.tenant_participant_role import TenantParticipantRole
from typing import Optional, Set
from typing_extensions import Self

class ResolvedIdentity(BaseModel):
    """
    The identity of the authenticated user.
    """ # noqa: E501
    authentication_type: AuthenticationType
    credential_type: StrictStr
    organization_id: Optional[UUID] = None
    tenant_id: Optional[UUID] = None
    participant_id: Optional[UUID] = None
    agent_id: Optional[UUID] = None
    thread_id: Optional[UUID] = None
    participant_read_only_paths: Optional[List[StrictStr]] = None
    participant_read_write_paths: Optional[List[StrictStr]] = None
    participant_role: Optional[TenantParticipantRole] = None
    token: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["authentication_type", "credential_type", "organization_id", "tenant_id", "participant_id", "agent_id", "thread_id", "participant_read_only_paths", "participant_read_write_paths", "participant_role", "token"]

    @field_validator('credential_type')
    def credential_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['TENANT', 'ORGANIZATION', 'ADMIN', 'USER', 'KS_THREAD', 'KS_IDENTITY']):
            raise ValueError("must be one of enum values ('TENANT', 'ORGANIZATION', 'ADMIN', 'USER', 'KS_THREAD', 'KS_IDENTITY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResolvedIdentity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResolvedIdentity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "authentication_type": obj.get("authentication_type"),
            "credential_type": obj.get("credential_type"),
            "organization_id": obj.get("organization_id"),
            "tenant_id": obj.get("tenant_id"),
            "participant_id": obj.get("participant_id"),
            "agent_id": obj.get("agent_id"),
            "thread_id": obj.get("thread_id"),
            "participant_read_only_paths": obj.get("participant_read_only_paths"),
            "participant_read_write_paths": obj.get("participant_read_write_paths"),
            "participant_role": obj.get("participant_role"),
            "token": obj.get("token")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


