# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: f70a944
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.participant_type import ParticipantType
from knowledge_stack.models.tenant_participant_role import TenantParticipantRole
from typing import Optional, Set
from typing_extensions import Self

class PublicApiSchemasResponsesParticipantRespParticipant(BaseModel):
    """
    Response schema for a participant.
    """ # noqa: E501
    id: UUID = Field(description="The ID of the participant")
    name: StrictStr = Field(description="The name of the participant")
    description: Optional[StrictStr] = Field(default=None, description="The description of the participant")
    participant_type: ParticipantType = Field(description="The type of participant (USER or AGENT)")
    email: Optional[StrictStr] = Field(default=None, description="Email address (for USER type)")
    idp_user_id: Optional[StrictStr] = Field(default=None, description="IdP user ID (for USER type)")
    url: Optional[StrictStr] = Field(default=None, description="Agent URL (for AGENT type)")
    api_key: Optional[StrictStr] = Field(default=None, description="Agent API key (for AGENT type)")
    created_at: datetime = Field(description="The timestamp when the participant was created")
    updated_at: datetime = Field(description="The timestamp when the participant was updated")
    role: TenantParticipantRole = Field(description="The role of the participant")
    read_only_paths: List[StrictStr] = Field(description="Paths that the participant can read from")
    read_write_paths: List[StrictStr] = Field(description="Paths that the participant can read from and write to")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "participant_type", "email", "idp_user_id", "url", "api_key", "created_at", "updated_at", "role", "read_only_paths", "read_write_paths"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicApiSchemasResponsesParticipantRespParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicApiSchemasResponsesParticipantRespParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "participant_type": obj.get("participant_type"),
            "email": obj.get("email"),
            "idp_user_id": obj.get("idp_user_id"),
            "url": obj.get("url"),
            "api_key": obj.get("api_key"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "role": obj.get("role"),
            "read_only_paths": obj.get("read_only_paths"),
            "read_write_paths": obj.get("read_write_paths")
        })
        return _obj


