# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 094d163
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Optional
from uuid import UUID
from knowledge_stack.models.document_processing_status import DocumentProcessingStatus
from knowledge_stack.models.document_version_metadata import DocumentVersionMetadata
from typing import Optional, Set
from typing_extensions import Self

class RespDocumentVersion(BaseModel):
    """
    Clean document version response schema.
    """ # noqa: E501
    id: UUID = Field(description="The unique identifier for the document version")
    document_id: UUID = Field(description="The ID of the document")
    version_number: StrictInt = Field(description="The version number")
    document_hash: StrictStr = Field(description="The hash of the file")
    processing_status: DocumentProcessingStatus = Field(description="The processing status of the document version")
    document_version_metadata: DocumentVersionMetadata = Field(description="The metadata of the document version")
    active_chunk_container_id: Optional[UUID] = Field(default=None, description="ID of the active chunk container")
    asset_download_url: Optional[StrictStr] = Field(default=None, description="The presigned URL of the document version")
    __properties: ClassVar[List[str]] = ["id", "document_id", "version_number", "document_hash", "processing_status", "document_version_metadata", "active_chunk_container_id", "asset_download_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespDocumentVersion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_version_metadata
        if self.document_version_metadata:
            _dict['document_version_metadata'] = self.document_version_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespDocumentVersion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "document_id": obj.get("document_id"),
            "version_number": obj.get("version_number"),
            "document_hash": obj.get("document_hash"),
            "processing_status": obj.get("processing_status"),
            "document_version_metadata": DocumentVersionMetadata.from_dict(obj["document_version_metadata"]) if obj.get("document_version_metadata") is not None else None,
            "active_chunk_container_id": obj.get("active_chunk_container_id"),
            "asset_download_url": obj.get("asset_download_url")
        })
        return _obj


