# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 094d163
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from uuid import UUID
from knowledge_stack.models.invite_status import InviteStatus
from typing import Optional, Set
from typing_extensions import Self

class RespInvite(BaseModel):
    """
    Invite response schema.
    """ # noqa: E501
    id: UUID = Field(description="The unique identifier for the job")
    tenant_id: UUID = Field(description="The ID of the tenant")
    email: StrictStr = Field(description="The email of the invitee")
    status: InviteStatus = Field(description="The status of the invite")
    accepted_at: Optional[datetime] = Field(default=None, description="When the invite was accepted")
    created_at: datetime = Field(description="The creation timestamp of the invite")
    updated_at: datetime = Field(description="The last update timestamp of the invite")
    __properties: ClassVar[List[str]] = ["id", "tenant_id", "email", "status", "accepted_at", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespInvite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespInvite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "tenant_id": obj.get("tenant_id"),
            "email": obj.get("email"),
            "status": obj.get("status"),
            "accepted_at": obj.get("accepted_at"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


