# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: b13bc20
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.resp_tag import RespTag
from typing import Optional, Set
from typing_extensions import Self

class RespFolder(BaseModel):
    """
    Clean folder response schema.
    """ # noqa: E501
    id: UUID = Field(description="The unique identifier for the folder")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(description="The name of the folder")
    parent_id: Optional[UUID] = Field(default=None, description="The ID of the parent folder")
    folder_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Folder metadata that allows arbitrary keys.")
    created_at: datetime = Field(description="When the folder was created")
    updated_at: datetime = Field(description="When the folder was last updated")
    tags: Optional[List[RespTag]] = Field(default=None, description="Tags associated with the folder")
    folder_path: StrictStr = Field(description="The full path of the folder (e.g., '/folder1/folder2')")
    document_count: Optional[StrictInt] = Field(default=0, description="Number of documents in the folder")
    subfolder_count: Optional[StrictInt] = Field(default=0, description="Number of subfolders in the folder")
    __properties: ClassVar[List[str]] = ["id", "name", "parent_id", "folder_metadata", "created_at", "updated_at", "tags", "folder_path", "document_count", "subfolder_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespFolder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespFolder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "parent_id": obj.get("parent_id"),
            "folder_metadata": obj.get("folder_metadata"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "tags": [RespTag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "folder_path": obj.get("folder_path"),
            "document_count": obj.get("document_count") if obj.get("document_count") is not None else 0,
            "subfolder_count": obj.get("subfolder_count") if obj.get("subfolder_count") is not None else 0
        })
        return _obj


