# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 882939d
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, Optional
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.tag_source_output import TagSourceOutput
from typing import Optional, Set
from typing_extensions import Self

class RespTagCreate(BaseModel):
    """
    Clean tag creation response schema.
    """ # noqa: E501
    id: UUID = Field(description="The unique identifier for the tag")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(description="The name of the tag")
    color: Annotated[str, Field(strict=True)] = Field(description="Hex color code for the tag")
    description: Optional[StrictStr] = Field(default=None, description="The description of the tag")
    tag_source: TagSourceOutput = Field(description="Source of the tag (system, tenant, or organization)")
    __properties: ClassVar[List[str]] = ["id", "name", "color", "description", "tag_source"]

    @field_validator('color')
    def color_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^#[0-9A-Fa-f]{6}$", value):
            raise ValueError(r"must validate the regular expression /^#[0-9A-Fa-f]{6}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespTagCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespTagCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "color": obj.get("color"),
            "description": obj.get("description"),
            "tag_source": obj.get("tag_source")
        })
        return _obj


