# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 80b68dd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.paginated_response_resp_chunk import PaginatedResponseRespChunk
from knowledge_stack.models.req_update_chunk_validation import ReqUpdateChunkValidation
from knowledge_stack.models.resp_chunk import RespChunk
from knowledge_stack.models.resp_chunk_lineage import RespChunkLineage

from knowledge_stack.api_client import ApiClient, RequestSerialized
from knowledge_stack.api_response import ApiResponse
from knowledge_stack.rest import RESTResponseType


class ChunksApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_chunk_content(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        chunk_container_id: Annotated[UUID, Field(description="The chunk container ID")],
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RespChunk:
        """Get Chunk

        Get a specific chunk by ID and container ID.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param chunk_container_id: The chunk container ID (required)
        :type chunk_container_id: str
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_chunk_content_serialize(
            tenant_id=tenant_id,
            chunk_id=chunk_id,
            chunk_container_id=chunk_container_id,
            asset_download_url_expiration=asset_download_url_expiration,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_chunk_content_with_http_info(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        chunk_container_id: Annotated[UUID, Field(description="The chunk container ID")],
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RespChunk]:
        """Get Chunk

        Get a specific chunk by ID and container ID.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param chunk_container_id: The chunk container ID (required)
        :type chunk_container_id: str
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_chunk_content_serialize(
            tenant_id=tenant_id,
            chunk_id=chunk_id,
            chunk_container_id=chunk_container_id,
            asset_download_url_expiration=asset_download_url_expiration,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_chunk_content_without_preload_content(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        chunk_container_id: Annotated[UUID, Field(description="The chunk container ID")],
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Chunk

        Get a specific chunk by ID and container ID.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param chunk_container_id: The chunk container ID (required)
        :type chunk_container_id: str
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_chunk_content_serialize(
            tenant_id=tenant_id,
            chunk_id=chunk_id,
            chunk_container_id=chunk_container_id,
            asset_download_url_expiration=asset_download_url_expiration,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_chunk_content_serialize(
        self,
        tenant_id,
        chunk_id,
        chunk_container_id,
        asset_download_url_expiration,
        ks_uat,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenant_id'] = tenant_id
        if chunk_id is not None:
            _path_params['chunk_id'] = chunk_id
        # process the query parameters
        if chunk_container_id is not None:
            
            _query_params.append(('chunk_container_id', chunk_container_id))
            
        if asset_download_url_expiration is not None:
            
            _query_params.append(('asset_download_url_expiration', asset_download_url_expiration))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/tenant/{tenant_id}/chunks/{chunk_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_chunk_lineage(
        self,
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        depth: Annotated[Optional[StrictInt], Field(description="The depth of the lineage")] = None,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RespChunkLineage:
        """Get chunk lineage

        Get the lineage of a specific chunk.

        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param depth: The depth of the lineage
        :type depth: int
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_chunk_lineage_serialize(
            chunk_id=chunk_id,
            tenant_id=tenant_id,
            depth=depth,
            asset_download_url_expiration=asset_download_url_expiration,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunkLineage",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_chunk_lineage_with_http_info(
        self,
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        depth: Annotated[Optional[StrictInt], Field(description="The depth of the lineage")] = None,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RespChunkLineage]:
        """Get chunk lineage

        Get the lineage of a specific chunk.

        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param depth: The depth of the lineage
        :type depth: int
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_chunk_lineage_serialize(
            chunk_id=chunk_id,
            tenant_id=tenant_id,
            depth=depth,
            asset_download_url_expiration=asset_download_url_expiration,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunkLineage",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_chunk_lineage_without_preload_content(
        self,
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        depth: Annotated[Optional[StrictInt], Field(description="The depth of the lineage")] = None,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get chunk lineage

        Get the lineage of a specific chunk.

        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param depth: The depth of the lineage
        :type depth: int
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_chunk_lineage_serialize(
            chunk_id=chunk_id,
            tenant_id=tenant_id,
            depth=depth,
            asset_download_url_expiration=asset_download_url_expiration,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunkLineage",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_chunk_lineage_serialize(
        self,
        chunk_id,
        tenant_id,
        depth,
        asset_download_url_expiration,
        ks_uat,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if chunk_id is not None:
            _path_params['chunk_id'] = chunk_id
        if tenant_id is not None:
            _path_params['tenant_id'] = tenant_id
        # process the query parameters
        if depth is not None:
            
            _query_params.append(('depth', depth))
            
        if asset_download_url_expiration is not None:
            
            _query_params.append(('asset_download_url_expiration', asset_download_url_expiration))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/tenant/{tenant_id}/chunks/{chunk_id}/lineage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_chunks(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_container_id: Annotated[Optional[UUID], Field(description="The chunk container ID")] = None,
        document_version_id: Annotated[Optional[UUID], Field(description="The document version ID")] = None,
        seq_num: Annotated[Optional[StrictInt], Field(description="The chunk sequence number")] = None,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items to skip")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedResponseRespChunk:
        """List Chunks

        List chunks for a document version using its active chunk container.  This endpoint retrieves chunks by finding the document version's active chunk container and then listing all chunks within that container.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_container_id: The chunk container ID
        :type chunk_container_id: str
        :param document_version_id: The document version ID
        :type document_version_id: str
        :param seq_num: The chunk sequence number
        :type seq_num: int
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param limit: Number of items per page
        :type limit: int
        :param offset: Number of items to skip
        :type offset: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_chunks_serialize(
            tenant_id=tenant_id,
            chunk_container_id=chunk_container_id,
            document_version_id=document_version_id,
            seq_num=seq_num,
            asset_download_url_expiration=asset_download_url_expiration,
            limit=limit,
            offset=offset,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedResponseRespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_chunks_with_http_info(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_container_id: Annotated[Optional[UUID], Field(description="The chunk container ID")] = None,
        document_version_id: Annotated[Optional[UUID], Field(description="The document version ID")] = None,
        seq_num: Annotated[Optional[StrictInt], Field(description="The chunk sequence number")] = None,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items to skip")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedResponseRespChunk]:
        """List Chunks

        List chunks for a document version using its active chunk container.  This endpoint retrieves chunks by finding the document version's active chunk container and then listing all chunks within that container.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_container_id: The chunk container ID
        :type chunk_container_id: str
        :param document_version_id: The document version ID
        :type document_version_id: str
        :param seq_num: The chunk sequence number
        :type seq_num: int
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param limit: Number of items per page
        :type limit: int
        :param offset: Number of items to skip
        :type offset: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_chunks_serialize(
            tenant_id=tenant_id,
            chunk_container_id=chunk_container_id,
            document_version_id=document_version_id,
            seq_num=seq_num,
            asset_download_url_expiration=asset_download_url_expiration,
            limit=limit,
            offset=offset,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedResponseRespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_chunks_without_preload_content(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_container_id: Annotated[Optional[UUID], Field(description="The chunk container ID")] = None,
        document_version_id: Annotated[Optional[UUID], Field(description="The document version ID")] = None,
        seq_num: Annotated[Optional[StrictInt], Field(description="The chunk sequence number")] = None,
        asset_download_url_expiration: Annotated[Optional[Annotated[int, Field(le=7200, strict=True, ge=0)]], Field(description="The expiration time of the asset download URL in seconds")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items to skip")] = None,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Chunks

        List chunks for a document version using its active chunk container.  This endpoint retrieves chunks by finding the document version's active chunk container and then listing all chunks within that container.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_container_id: The chunk container ID
        :type chunk_container_id: str
        :param document_version_id: The document version ID
        :type document_version_id: str
        :param seq_num: The chunk sequence number
        :type seq_num: int
        :param asset_download_url_expiration: The expiration time of the asset download URL in seconds
        :type asset_download_url_expiration: int
        :param limit: Number of items per page
        :type limit: int
        :param offset: Number of items to skip
        :type offset: int
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_chunks_serialize(
            tenant_id=tenant_id,
            chunk_container_id=chunk_container_id,
            document_version_id=document_version_id,
            seq_num=seq_num,
            asset_download_url_expiration=asset_download_url_expiration,
            limit=limit,
            offset=offset,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedResponseRespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_chunks_serialize(
        self,
        tenant_id,
        chunk_container_id,
        document_version_id,
        seq_num,
        asset_download_url_expiration,
        limit,
        offset,
        ks_uat,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenant_id'] = tenant_id
        # process the query parameters
        if chunk_container_id is not None:
            
            _query_params.append(('chunk_container_id', chunk_container_id))
            
        if document_version_id is not None:
            
            _query_params.append(('document_version_id', document_version_id))
            
        if seq_num is not None:
            
            _query_params.append(('seq_num', seq_num))
            
        if asset_download_url_expiration is not None:
            
            _query_params.append(('asset_download_url_expiration', asset_download_url_expiration))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/tenant/{tenant_id}/chunks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_chunk_validation(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        req_update_chunk_validation: ReqUpdateChunkValidation,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RespChunk:
        """Update Chunk Validation

        Update the validation status of a specific chunk by ID.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param req_update_chunk_validation: (required)
        :type req_update_chunk_validation: ReqUpdateChunkValidation
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_chunk_validation_serialize(
            tenant_id=tenant_id,
            chunk_id=chunk_id,
            req_update_chunk_validation=req_update_chunk_validation,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_chunk_validation_with_http_info(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        req_update_chunk_validation: ReqUpdateChunkValidation,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RespChunk]:
        """Update Chunk Validation

        Update the validation status of a specific chunk by ID.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param req_update_chunk_validation: (required)
        :type req_update_chunk_validation: ReqUpdateChunkValidation
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_chunk_validation_serialize(
            tenant_id=tenant_id,
            chunk_id=chunk_id,
            req_update_chunk_validation=req_update_chunk_validation,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_chunk_validation_without_preload_content(
        self,
        tenant_id: Annotated[UUID, Field(description="The tenant ID")],
        chunk_id: Annotated[UUID, Field(description="The chunk ID")],
        req_update_chunk_validation: ReqUpdateChunkValidation,
        ks_uat: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Chunk Validation

        Update the validation status of a specific chunk by ID.

        :param tenant_id: The tenant ID (required)
        :type tenant_id: str
        :param chunk_id: The chunk ID (required)
        :type chunk_id: str
        :param req_update_chunk_validation: (required)
        :type req_update_chunk_validation: ReqUpdateChunkValidation
        :param ks_uat:
        :type ks_uat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_chunk_validation_serialize(
            tenant_id=tenant_id,
            chunk_id=chunk_id,
            req_update_chunk_validation=req_update_chunk_validation,
            ks_uat=ks_uat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RespChunk",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_chunk_validation_serialize(
        self,
        tenant_id,
        chunk_id,
        req_update_chunk_validation,
        ks_uat,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenant_id'] = tenant_id
        if chunk_id is not None:
            _path_params['chunk_id'] = chunk_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if req_update_chunk_validation is not None:
            _body_params = req_update_chunk_validation


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v1/tenant/{tenant_id}/chunks/{chunk_id}/validation',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


