# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 80b68dd
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class PublicRespChunkMetadata(BaseModel):
    """
    Public API chunk metadata schema for responses.
    """ # noqa: E501
    polygon: Optional[Dict[str, List[Annotated[List[Any], Field(min_length=2, max_length=2)]]]] = Field(default=None, description="The bounding polygons of the chunk. If box, the list should have exactly 4 points.")
    section_name: Optional[StrictStr] = Field(default=None, description="The closest hierarchy this chunk belongs to")
    page_start: Optional[StrictInt] = Field(default=0, description="The page number of the first page of the chunk")
    page_end: Optional[StrictInt] = Field(default=0, description="The page number of the last page of the chunk")
    hierarchy_level: Optional[StrictInt] = Field(default=0, description="The level of the chunk's hierarchy")
    hierarchy_path: Optional[StrictStr] = Field(default='', description="The chunk's hierarchy in slash notation")
    title: Optional[StrictStr] = Field(default=None, description="The title of the chunk")
    category: Optional[StrictStr] = Field(default=None, description="The category of the table/image")
    sequence_number: Optional[StrictInt] = Field(default=-1, description="The sequence number of the chunk")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["polygon", "section_name", "page_start", "page_end", "hierarchy_level", "hierarchy_path", "title", "category", "sequence_number"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicRespChunkMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicRespChunkMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "polygon": obj.get("polygon"),
            "section_name": obj.get("section_name"),
            "page_start": obj.get("page_start") if obj.get("page_start") is not None else 0,
            "page_end": obj.get("page_end") if obj.get("page_end") is not None else 0,
            "hierarchy_level": obj.get("hierarchy_level") if obj.get("hierarchy_level") is not None else 0,
            "hierarchy_path": obj.get("hierarchy_path") if obj.get("hierarchy_path") is not None else '',
            "title": obj.get("title"),
            "category": obj.get("category"),
            "sequence_number": obj.get("sequence_number") if obj.get("sequence_number") is not None else -1
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


