# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 33585ef
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.base_participant import BaseParticipant
from knowledge_stack.models.resp_chunk import RespChunk
from typing import Optional, Set
from typing_extensions import Self

class RespTurn(BaseModel):
    """
    RespTurn
    """ # noqa: E501
    id: UUID = Field(description="Turn ID")
    thread_id: UUID = Field(description="Thread ID")
    sequence_number: StrictInt = Field(description="Sequence number of the turn")
    chunk_container_id: UUID = Field(description="Chunk container ID")
    created_at: datetime = Field(description="Creation timestamp")
    chunks: Optional[List[RespChunk]] = Field(default=None, description="The chunks in the turn")
    participant: BaseParticipant = Field(description="The participant of the turn")
    __properties: ClassVar[List[str]] = ["id", "thread_id", "sequence_number", "chunk_container_id", "created_at", "chunks", "participant"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespTurn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in chunks (list)
        _items = []
        if self.chunks:
            for _item_chunks in self.chunks:
                if _item_chunks:
                    _items.append(_item_chunks.to_dict())
            _dict['chunks'] = _items
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespTurn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "thread_id": obj.get("thread_id"),
            "sequence_number": obj.get("sequence_number"),
            "chunk_container_id": obj.get("chunk_container_id"),
            "created_at": obj.get("created_at"),
            "chunks": [RespChunk.from_dict(_item) for _item in obj["chunks"]] if obj.get("chunks") is not None else None,
            "participant": BaseParticipant.from_dict(obj["participant"]) if obj.get("participant") is not None else None
        })
        return _obj


