# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 33585ef
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.participant_type import ParticipantType
from typing import Optional, Set
from typing_extensions import Self

class RespTurnCreate(BaseModel):
    """
    RespTurnCreate
    """ # noqa: E501
    id: UUID = Field(description="Turn ID")
    thread_id: UUID = Field(description="Thread ID")
    sequence_number: StrictInt = Field(description="Sequence number of the turn")
    chunk_container_id: UUID = Field(description="Chunk container ID")
    created_at: datetime = Field(description="Creation timestamp")
    participant_id: UUID = Field(description="Participant ID")
    participant_type: ParticipantType = Field(description="The type of participant (USER or AGENT)")
    participant_name: StrictStr = Field(description="The name of the participant")
    relevant_folder_paths: Optional[List[Dict[str, Any]]] = Field(default=None, description="Snapshot of relevant folder paths at creation time")
    relevant_tags: Optional[List[Dict[str, Any]]] = Field(default=None, description="Snapshot of relevant tags at creation time")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "thread_id", "sequence_number", "chunk_container_id", "created_at", "participant_id", "participant_type", "participant_name", "relevant_folder_paths", "relevant_tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespTurnCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespTurnCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "thread_id": obj.get("thread_id"),
            "sequence_number": obj.get("sequence_number"),
            "chunk_container_id": obj.get("chunk_container_id"),
            "created_at": obj.get("created_at"),
            "participant_id": obj.get("participant_id"),
            "participant_type": obj.get("participant_type"),
            "participant_name": obj.get("participant_name"),
            "relevant_folder_paths": obj.get("relevant_folder_paths"),
            "relevant_tags": obj.get("relevant_tags")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


