# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 33585ef
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict
from knowledge_stack.models.tenant_idp_type import TenantIdpType
from typing import Optional, Set
from typing_extensions import Self

class RespUserIdentity(BaseModel):
    """
    Identity payload for KS IdP users.
    """ # noqa: E501
    identity_token: StrictStr = Field(description="Identity JWT")
    tenant_idp_type: TenantIdpType = Field(description="Tenant IdP type")
    idp_user_id: StrictStr = Field(description="IdP user identifier")
    email: StrictStr = Field(description="User email")
    name: StrictStr = Field(description="User display name")
    email_verified: StrictBool = Field(description="Whether the email is verified")
    __properties: ClassVar[List[str]] = ["identity_token", "tenant_idp_type", "idp_user_id", "email", "name", "email_verified"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespUserIdentity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespUserIdentity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "identity_token": obj.get("identity_token"),
            "tenant_idp_type": obj.get("tenant_idp_type"),
            "idp_user_id": obj.get("idp_user_id"),
            "email": obj.get("email"),
            "name": obj.get("name"),
            "email_verified": obj.get("email_verified")
        })
        return _obj


