# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: bb7ec97
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.category import Category
from knowledge_stack.models.chunk_type import ChunkType
from typing import Optional, Set
from typing_extensions import Self

class ReqSearchChunks(BaseModel):
    """
    ReqSearchChunks
    """ # noqa: E501
    query: Annotated[str, Field(min_length=1, strict=True, max_length=10000)] = Field(description="The query to search for")
    top_k: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(default=10, description="Number of top results to return")
    score_threshold: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=0.7, description="Minimum similarity score threshold")
    oversampling_factor: Optional[Union[Annotated[float, Field(le=10.0, strict=True, ge=1.0)], Annotated[int, Field(le=10, strict=True, ge=1)]]] = Field(default=None, description="Prefetch multiplier for fusion/reranking queries")
    tag_names: Optional[Annotated[List[StrictStr], Field(max_length=10)]] = Field(default=None, description="Optional list of tag names to filter search results")
    tag_ids: Optional[Annotated[List[UUID], Field(max_length=10)]] = Field(default=None, description="Optional list of tag IDs to filter search results")
    chunk_type: Optional[ChunkType] = Field(default=None, description="Optional chunk type to filter search results")
    category: Optional[Category] = None
    folder_paths: Optional[List[StrictStr]] = Field(default=None, description="Folder paths to restrict search results to (includes all descendants). Use format: '/Documents/subfolder' or '/Threads/{thread_id}'")
    folder_ids: Optional[List[UUID]] = Field(default=None, description="Parent folder IDs to restrict search results to")
    search_mode: Optional[StrictStr] = Field(default=None, description="Optional search mode to use")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["query", "top_k", "score_threshold", "oversampling_factor", "tag_names", "tag_ids", "chunk_type", "category", "folder_paths", "folder_ids", "search_mode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReqSearchChunks from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of category
        if self.category:
            _dict['category'] = self.category.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReqSearchChunks from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "query": obj.get("query"),
            "top_k": obj.get("top_k") if obj.get("top_k") is not None else 10,
            "score_threshold": obj.get("score_threshold") if obj.get("score_threshold") is not None else 0.7,
            "oversampling_factor": obj.get("oversampling_factor"),
            "tag_names": obj.get("tag_names"),
            "tag_ids": obj.get("tag_ids"),
            "chunk_type": obj.get("chunk_type"),
            "category": Category.from_dict(obj["category"]) if obj.get("category") is not None else None,
            "folder_paths": obj.get("folder_paths"),
            "folder_ids": obj.get("folder_ids"),
            "search_mode": obj.get("search_mode")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


