# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: bb7ec97
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.resp_tag import RespTag
from typing import Optional, Set
from typing_extensions import Self

class RespAsyncIngest(BaseModel):
    """
    Async ingestion task metadata.
    """ # noqa: E501
    message: StrictStr = Field(description="Status message")
    status: StrictStr = Field(description="Queue status")
    pipeline: StrictStr = Field(description="Pipeline identifier")
    version: StrictStr = Field(description="Pipeline version")
    tenant_id: UUID = Field(description="Tenant identifier")
    document_id: UUID = Field(description="Document identifier")
    document_version_id: UUID = Field(description="Document version identifier")
    job_id: UUID = Field(description="Job identifier")
    task_status_url: StrictStr = Field(description="URL to poll task status")
    tags: Optional[List[RespTag]] = Field(default=None, description="Tags applied")
    __properties: ClassVar[List[str]] = ["message", "status", "pipeline", "version", "tenant_id", "document_id", "document_version_id", "job_id", "task_status_url", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespAsyncIngest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespAsyncIngest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message": obj.get("message"),
            "status": obj.get("status"),
            "pipeline": obj.get("pipeline"),
            "version": obj.get("version"),
            "tenant_id": obj.get("tenant_id"),
            "document_id": obj.get("document_id"),
            "document_version_id": obj.get("document_version_id"),
            "job_id": obj.get("job_id"),
            "task_status_url": obj.get("task_status_url"),
            "tags": [RespTag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None
        })
        return _obj


