# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: bb7ec97
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.resp_document_summary import RespDocumentSummary
from knowledge_stack.models.resp_folder import RespFolder
from typing import Optional, Set
from typing_extensions import Self

class RespFolderContents(BaseModel):
    """
    Aggregated folder contents listing.
    """ # noqa: E501
    folder_id: Optional[UUID] = Field(default=None, description="Folder identifier for the listed contents")
    folders: Optional[List[RespFolder]] = Field(default=None, description="Subfolders")
    documents: Optional[List[RespDocumentSummary]] = Field(default=None, description="Documents within the folder")
    folder_count: Optional[StrictInt] = Field(default=0, description="Count of subfolders")
    document_count: Optional[StrictInt] = Field(default=0, description="Count of documents")
    total_count: Optional[StrictInt] = Field(default=0, description="Total items count")
    limit: Optional[StrictInt] = Field(default=None, description="Page size")
    offset: Optional[StrictInt] = Field(default=None, description="Pagination offset")
    __properties: ClassVar[List[str]] = ["folder_id", "folders", "documents", "folder_count", "document_count", "total_count", "limit", "offset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespFolderContents from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in folders (list)
        _items = []
        if self.folders:
            for _item_folders in self.folders:
                if _item_folders:
                    _items.append(_item_folders.to_dict())
            _dict['folders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in documents (list)
        _items = []
        if self.documents:
            for _item_documents in self.documents:
                if _item_documents:
                    _items.append(_item_documents.to_dict())
            _dict['documents'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespFolderContents from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "folder_id": obj.get("folder_id"),
            "folders": [RespFolder.from_dict(_item) for _item in obj["folders"]] if obj.get("folders") is not None else None,
            "documents": [RespDocumentSummary.from_dict(_item) for _item in obj["documents"]] if obj.get("documents") is not None else None,
            "folder_count": obj.get("folder_count") if obj.get("folder_count") is not None else 0,
            "document_count": obj.get("document_count") if obj.get("document_count") is not None else 0,
            "total_count": obj.get("total_count") if obj.get("total_count") is not None else 0,
            "limit": obj.get("limit"),
            "offset": obj.get("offset")
        })
        return _obj


