# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: bb7ec97
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.base_participant import BaseParticipant
from knowledge_stack.models.paginated_response_resp_turn import PaginatedResponseRespTurn
from typing import Optional, Set
from typing_extensions import Self

class RespThread(BaseModel):
    """
    RespThread
    """ # noqa: E501
    agent_id: UUID = Field(description="The ID of the agent")
    agent_name: StrictStr = Field(description="The name of the agent")
    agent_url: StrictStr = Field(description="The URL of the agent")
    agent_thread_token: Optional[StrictStr] = Field(default='', description="The authentication token to authenticate with the agent for this thread. May be empty if agent is temporarily unreachable - agent can authenticate later.")
    thread_id: UUID = Field(description="The ID of the thread")
    title: Optional[StrictStr] = Field(default=None, description="The title of the thread")
    description: Optional[StrictStr] = Field(default=None, description="The description of the thread")
    created_at: datetime = Field(description="The timestamp of the thread")
    updated_at: datetime = Field(description="The timestamp of the thread")
    has_agent: Optional[StrictBool] = Field(default=False, description="Whether the thread currently has an agent participant")
    agent: Optional[BaseParticipant] = Field(default=None, description="The agent of the thread if one exists")
    users: Optional[Annotated[List[BaseParticipant], Field(max_length=20)]] = Field(default=None, description="The users of the thread")
    turns: PaginatedResponseRespTurn = Field(description="The last N turns in the thread")
    __properties: ClassVar[List[str]] = ["agent_id", "agent_name", "agent_url", "agent_thread_token", "thread_id", "title", "description", "created_at", "updated_at", "has_agent", "agent", "users", "turns"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespThread from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of agent
        if self.agent:
            _dict['agent'] = self.agent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of turns
        if self.turns:
            _dict['turns'] = self.turns.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespThread from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agent_id": obj.get("agent_id"),
            "agent_name": obj.get("agent_name"),
            "agent_url": obj.get("agent_url"),
            "agent_thread_token": obj.get("agent_thread_token") if obj.get("agent_thread_token") is not None else '',
            "thread_id": obj.get("thread_id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "has_agent": obj.get("has_agent") if obj.get("has_agent") is not None else False,
            "agent": BaseParticipant.from_dict(obj["agent"]) if obj.get("agent") is not None else None,
            "users": [BaseParticipant.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "turns": PaginatedResponseRespTurn.from_dict(obj["turns"]) if obj.get("turns") is not None else None
        })
        return _obj


