# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 55b8478
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from knowledge_stack.models.document_processing_status import DocumentProcessingStatus
from knowledge_stack.models.job_status_output import JobStatusOutput
from knowledge_stack.models.processing_stage import ProcessingStage
from knowledge_stack.models.resp_document_version import RespDocumentVersion
from knowledge_stack.models.resp_tag import RespTag
from typing import Optional, Set
from typing_extensions import Self

class RespDocument(BaseModel):
    """
    Document details exposed to public API consumers.
    """ # noqa: E501
    id: UUID = Field(description="Document identifier")
    name: StrictStr = Field(description="Document name")
    tenant_id: UUID = Field(description="Tenant identifier")
    folder_id: Optional[UUID] = Field(default=None, description="Folder containing the document")
    document_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Flexible document metadata that allows arbitrary keys.")
    document_status: DocumentProcessingStatus = Field(description="Processing status of the document")
    job_status: JobStatusOutput = Field(description="Latest job status")
    job_progress: Union[StrictFloat, StrictInt] = Field(description="Job progress percentage")
    job_stage: ProcessingStage = Field(description="Current processing stage")
    active_version: RespDocumentVersion = Field(description="Active document version details")
    tags: Optional[List[RespTag]] = Field(default=None, description="Tags on the document")
    created_at: datetime = Field(description="Creation timestamp")
    updated_at: datetime = Field(description="Last update timestamp")
    __properties: ClassVar[List[str]] = ["id", "name", "tenant_id", "folder_id", "document_metadata", "document_status", "job_status", "job_progress", "job_stage", "active_version", "tags", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of active_version
        if self.active_version:
            _dict['active_version'] = self.active_version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "tenant_id": obj.get("tenant_id"),
            "folder_id": obj.get("folder_id"),
            "document_metadata": obj.get("document_metadata"),
            "document_status": obj.get("document_status"),
            "job_status": obj.get("job_status"),
            "job_progress": obj.get("job_progress"),
            "job_stage": obj.get("job_stage"),
            "active_version": RespDocumentVersion.from_dict(obj["active_version"]) if obj.get("active_version") is not None else None,
            "tags": [RespTag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


