# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 55b8478
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.citation_item import CitationItem
from knowledge_stack.models.relevant_folder_path import RelevantFolderPath
from knowledge_stack.models.relevant_tag import RelevantTag
from knowledge_stack.models.turn_asset_item import TurnAssetItem
from typing import Optional, Set
from typing_extensions import Self

class TurnItem(BaseModel):
    """
    Schema for a turn creation.
    """ # noqa: E501
    turn_id: Optional[UUID] = Field(default=None, description="Optional turn ID; generated when omitted")
    participant_id: UUID = Field(description="Participant ID for this turn")
    message_content: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Message text content to be chunked and stored")
    assets: Optional[List[TurnAssetItem]] = Field(default=None, description="Optional list of assets (images/tables) associated with this turn. Content should be base64-encoded.")
    citations: Optional[List[CitationItem]] = Field(default=None, description="Optional citations to source chunks used to generate this turn")
    relevant_folder_paths: Optional[List[RelevantFolderPath]] = Field(default=None, description="Relevant folder paths (snapshot) to persist on the turn")
    relevant_tags: Optional[List[RelevantTag]] = Field(default=None, description="Relevant tags (snapshot) to persist on the turn")
    __properties: ClassVar[List[str]] = ["turn_id", "participant_id", "message_content", "assets", "citations", "relevant_folder_paths", "relevant_tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TurnItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict['assets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in citations (list)
        _items = []
        if self.citations:
            for _item_citations in self.citations:
                if _item_citations:
                    _items.append(_item_citations.to_dict())
            _dict['citations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relevant_folder_paths (list)
        _items = []
        if self.relevant_folder_paths:
            for _item_relevant_folder_paths in self.relevant_folder_paths:
                if _item_relevant_folder_paths:
                    _items.append(_item_relevant_folder_paths.to_dict())
            _dict['relevant_folder_paths'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relevant_tags (list)
        _items = []
        if self.relevant_tags:
            for _item_relevant_tags in self.relevant_tags:
                if _item_relevant_tags:
                    _items.append(_item_relevant_tags.to_dict())
            _dict['relevant_tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TurnItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "turn_id": obj.get("turn_id"),
            "participant_id": obj.get("participant_id"),
            "message_content": obj.get("message_content"),
            "assets": [TurnAssetItem.from_dict(_item) for _item in obj["assets"]] if obj.get("assets") is not None else None,
            "citations": [CitationItem.from_dict(_item) for _item in obj["citations"]] if obj.get("citations") is not None else None,
            "relevant_folder_paths": [RelevantFolderPath.from_dict(_item) for _item in obj["relevant_folder_paths"]] if obj.get("relevant_folder_paths") is not None else None,
            "relevant_tags": [RelevantTag.from_dict(_item) for _item in obj["relevant_tags"]] if obj.get("relevant_tags") is not None else None
        })
        return _obj


