# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 8779317
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from knowledge_stack.models.job_status_output import JobStatusOutput
from knowledge_stack.models.job_type import JobType
from knowledge_stack.models.processing_stage import ProcessingStage
from knowledge_stack.models.resource_type import ResourceType
from typing import Optional, Set
from typing_extensions import Self

class RespJob(BaseModel):
    """
    Job tracker response.
    """ # noqa: E501
    id: UUID = Field(description="Job identifier")
    tenant_id: UUID = Field(description="Tenant identifier")
    status: JobStatusOutput = Field(description="Job status")
    progress: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Job progress")
    completed_at: Optional[datetime] = Field(default=None, description="Completion timestamp if finished")
    processing_stage: ProcessingStage = Field(description="Processing stage of the job")
    job_type: JobType = Field(description="Type of job")
    resource_id: Optional[UUID] = Field(default=None, description="Resource id associated with the job")
    resource_type: Optional[ResourceType] = Field(default=None, description="Resource type associated with the job")
    error: Optional[StrictStr] = Field(default=None, description="Error message if any")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "tenant_id", "status", "progress", "completed_at", "processing_stage", "job_type", "resource_id", "resource_type", "error"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "tenant_id": obj.get("tenant_id"),
            "status": obj.get("status"),
            "progress": obj.get("progress") if obj.get("progress") is not None else 0.0,
            "completed_at": obj.get("completed_at"),
            "processing_stage": obj.get("processing_stage"),
            "job_type": obj.get("job_type"),
            "resource_id": obj.get("resource_id"),
            "resource_type": obj.get("resource_type"),
            "error": obj.get("error")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


