from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define

if TYPE_CHECKING:
    from ..models.empty_response import EmptyResponse


T = TypeVar("T", bound="DeleteFirewallRulesetResponse200")


@_attrs_define
class DeleteFirewallRulesetResponse200:
    """
    Attributes:
        data (EmptyResponse):
    """

    data: EmptyResponse

    def to_dict(self) -> dict[str, Any]:
        data = self.data.to_dict()

        field_dict: dict[str, Any] = {}

        field_dict.update(
            {
                "data": data,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.empty_response import EmptyResponse

        d = dict(src_dict)
        data = EmptyResponse.from_dict(d.pop("data"))

        delete_firewall_ruleset_response_200 = cls(
            data=data,
        )

        return delete_firewall_ruleset_response_200
