from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define

if TYPE_CHECKING:
    from ..models.instance_launch_response import InstanceLaunchResponse


T = TypeVar("T", bound="LaunchInstanceResponse200")


@_attrs_define
class LaunchInstanceResponse200:
    """
    Attributes:
        data (InstanceLaunchResponse):
    """

    data: InstanceLaunchResponse

    def to_dict(self) -> dict[str, Any]:
        data = self.data.to_dict()

        field_dict: dict[str, Any] = {}

        field_dict.update(
            {
                "data": data,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.instance_launch_response import InstanceLaunchResponse

        d = dict(src_dict)
        data = InstanceLaunchResponse.from_dict(d.pop("data"))

        launch_instance_response_200 = cls(
            data=data,
        )

        return launch_instance_response_200
