from http import HTTPStatus
from typing import Any

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.firewall_rules_put_request import FirewallRulesPutRequest
from ...models.firewall_rules_set_response_200 import FirewallRulesSetResponse200
from ...models.firewall_rules_set_response_401 import FirewallRulesSetResponse401
from ...models.firewall_rules_set_response_403 import FirewallRulesSetResponse403
from ...types import Response


def _get_kwargs(
    *,
    body: FirewallRulesPutRequest,
) -> dict[str, Any]:
    headers: dict[str, Any] = {}

    _kwargs: dict[str, Any] = {
        "method": "put",
        "url": "/api/v1/firewall-rules",
    }

    _kwargs["json"] = body.to_dict()

    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: AuthenticatedClient | Client, response: httpx.Response
) -> FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403 | None:
    if response.status_code == 200:
        response_200 = FirewallRulesSetResponse200.from_dict(response.json())

        return response_200

    if response.status_code == 401:
        response_401 = FirewallRulesSetResponse401.from_dict(response.json())

        return response_401

    if response.status_code == 403:
        response_403 = FirewallRulesSetResponse403.from_dict(response.json())

        return response_403

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: AuthenticatedClient | Client, response: httpx.Response
) -> Response[FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
    body: FirewallRulesPutRequest,
) -> Response[FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403]:
    """Replace inbound firewall rules

     Overwrites the inbound firewall rules currently active for your account's instances with the desired
    rules.

    **Note:** Firewall rules do not apply to the **us-south-1** region.

    Args:
        body (FirewallRulesPutRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403]
    """

    kwargs = _get_kwargs(
        body=body,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
    body: FirewallRulesPutRequest,
) -> FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403 | None:
    """Replace inbound firewall rules

     Overwrites the inbound firewall rules currently active for your account's instances with the desired
    rules.

    **Note:** Firewall rules do not apply to the **us-south-1** region.

    Args:
        body (FirewallRulesPutRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403
    """

    return sync_detailed(
        client=client,
        body=body,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
    body: FirewallRulesPutRequest,
) -> Response[FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403]:
    """Replace inbound firewall rules

     Overwrites the inbound firewall rules currently active for your account's instances with the desired
    rules.

    **Note:** Firewall rules do not apply to the **us-south-1** region.

    Args:
        body (FirewallRulesPutRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403]
    """

    kwargs = _get_kwargs(
        body=body,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient,
    body: FirewallRulesPutRequest,
) -> FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403 | None:
    """Replace inbound firewall rules

     Overwrites the inbound firewall rules currently active for your account's instances with the desired
    rules.

    **Note:** Firewall rules do not apply to the **us-south-1** region.

    Args:
        body (FirewallRulesPutRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        FirewallRulesSetResponse200 | FirewallRulesSetResponse401 | FirewallRulesSetResponse403
    """

    return (
        await asyncio_detailed(
            client=client,
            body=body,
        )
    ).parsed
