# coding: utf-8

"""
    Lambda Cloud API

    API for interacting with the Lambda GPU Cloud  # noqa: E501

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field
from lambda_cloud_client.models.error import Error

class ErrorResponseBody(BaseModel):
    """
    ErrorResponseBody
    """
    error: Error = Field(...)
    field_errors: Optional[Dict[str, Error]] = Field(None, description="Details about errors on a per-parameter basis")
    __properties = ["error", "field_errors"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorResponseBody:
        """Create an instance of ErrorResponseBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in field_errors (dict)
        _field_dict = {}
        if self.field_errors:
            for _key in self.field_errors:
                if self.field_errors[_key]:
                    _field_dict[_key] = self.field_errors[_key].to_dict()
            _dict['field_errors'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorResponseBody:
        """Create an instance of ErrorResponseBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorResponseBody.parse_obj(obj)

        _obj = ErrorResponseBody.parse_obj({
            "error": Error.from_dict(obj.get("error")) if obj.get("error") is not None else None,
            "field_errors": dict(
                (_k, Error.from_dict(_v))
                for _k, _v in obj.get("field_errors").items()
            )
            if obj.get("field_errors") is not None
            else None
        })
        return _obj

