# coding: utf-8

"""
    Lambda Cloud API

    API for interacting with the Lambda GPU Cloud  # noqa: E501

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictBool, StrictStr
from lambda_cloud_client.models.region import Region
from lambda_cloud_client.models.user import User

class FileSystem(BaseModel):
    """
    Information about a shared file system
    """
    id: StrictStr = Field(..., description="Unique identifier (ID) of a file system")
    name: StrictStr = Field(..., description="Name of a file system")
    created: StrictStr = Field(..., description="A date and time, formatted as an ISO 8601 time stamp")
    created_by: User = Field(...)
    mount_point: StrictStr = Field(..., description="Absolute path indicating where on instances the file system will be mounted")
    region: Region = Field(...)
    is_in_use: StrictBool = Field(..., description="Whether the file system is currently in use by an instance. File systems that are in use cannot be deleted.")
    __properties = ["id", "name", "created", "created_by", "mount_point", "region", "is_in_use"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FileSystem:
        """Create an instance of FileSystem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['created_by'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of region
        if self.region:
            _dict['region'] = self.region.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FileSystem:
        """Create an instance of FileSystem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FileSystem.parse_obj(obj)

        _obj = FileSystem.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "created": obj.get("created"),
            "created_by": User.from_dict(obj.get("created_by")) if obj.get("created_by") is not None else None,
            "mount_point": obj.get("mount_point"),
            "region": Region.from_dict(obj.get("region")) if obj.get("region") is not None else None,
            "is_in_use": obj.get("is_in_use")
        })
        return _obj

