# lambda-cloud-client
API for interacting with the Lambda GPU Cloud

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.4.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonNextgenClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lambda_cloud_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lambda_cloud_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import lambda_cloud_client
from lambda_cloud_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://cloud.lambdalabs.com/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = lambda_cloud_client.Configuration(
    host = "https://cloud.lambdalabs.com/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = lambda_cloud_client.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)

# Configure Bearer authorization (auth-scheme): bearerAuth
configuration = lambda_cloud_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with lambda_cloud_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = lambda_cloud_client.DefaultApi(api_client)
    add_ssh_key_request = lambda_cloud_client.AddSSHKeyRequest() # AddSSHKeyRequest | 

    try:
        # Add SSH key
        api_response = api_instance.add_ssh_key(add_ssh_key_request)
        print("The response of DefaultApi->add_ssh_key:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->add_ssh_key: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://cloud.lambdalabs.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**add_ssh_key**](docs/DefaultApi.md#add_ssh_key) | **POST** /ssh-keys | Add SSH key
*DefaultApi* | [**delete_ssh_key**](docs/DefaultApi.md#delete_ssh_key) | **DELETE** /ssh-keys/{id} | Delete SSH key
*DefaultApi* | [**get_instance**](docs/DefaultApi.md#get_instance) | **GET** /instances/{id} | List details of a specific instance
*DefaultApi* | [**instance_types**](docs/DefaultApi.md#instance_types) | **GET** /instance-types | Retrieve list of offered instance types
*DefaultApi* | [**launch_instance**](docs/DefaultApi.md#launch_instance) | **POST** /instance-operations/launch | Launch instances
*DefaultApi* | [**list_file_systems**](docs/DefaultApi.md#list_file_systems) | **GET** /file-systems | List file systems
*DefaultApi* | [**list_instances**](docs/DefaultApi.md#list_instances) | **GET** /instances | List running instances
*DefaultApi* | [**list_ssh_keys**](docs/DefaultApi.md#list_ssh_keys) | **GET** /ssh-keys | List SSH keys
*DefaultApi* | [**restart_instance**](docs/DefaultApi.md#restart_instance) | **POST** /instance-operations/restart | Restart instances
*DefaultApi* | [**terminate_instance**](docs/DefaultApi.md#terminate_instance) | **POST** /instance-operations/terminate | Terminate an instance


## Documentation For Models

 - [AddSSHKey200Response](docs/AddSSHKey200Response.md)
 - [AddSSHKeyRequest](docs/AddSSHKeyRequest.md)
 - [Error](docs/Error.md)
 - [ErrorCode](docs/ErrorCode.md)
 - [ErrorResponseBody](docs/ErrorResponseBody.md)
 - [FileSystem](docs/FileSystem.md)
 - [GetInstance200Response](docs/GetInstance200Response.md)
 - [Instance](docs/Instance.md)
 - [InstanceType](docs/InstanceType.md)
 - [InstanceTypeSpecs](docs/InstanceTypeSpecs.md)
 - [InstanceTypes200Response](docs/InstanceTypes200Response.md)
 - [InstanceTypes200ResponseDataValue](docs/InstanceTypes200ResponseDataValue.md)
 - [LaunchInstance200Response](docs/LaunchInstance200Response.md)
 - [LaunchInstance200ResponseData](docs/LaunchInstance200ResponseData.md)
 - [LaunchInstanceRequest](docs/LaunchInstanceRequest.md)
 - [ListFileSystems200Response](docs/ListFileSystems200Response.md)
 - [ListInstances200Response](docs/ListInstances200Response.md)
 - [ListSSHKeys200Response](docs/ListSSHKeys200Response.md)
 - [Region](docs/Region.md)
 - [RestartInstance200Response](docs/RestartInstance200Response.md)
 - [RestartInstance200ResponseData](docs/RestartInstance200ResponseData.md)
 - [RestartInstanceRequest](docs/RestartInstanceRequest.md)
 - [SshKey](docs/SshKey.md)
 - [TerminateInstance200Response](docs/TerminateInstance200Response.md)
 - [TerminateInstance200ResponseData](docs/TerminateInstance200ResponseData.md)
 - [TerminateInstanceRequest](docs/TerminateInstanceRequest.md)
 - [User](docs/User.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication

<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication (auth-scheme)


## Author




