# coding: utf-8

"""
    Lambda Cloud API

    API for interacting with the Lambda GPU Cloud  # noqa: E501

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictInt

class InstanceTypeSpecs(BaseModel):
    """
    InstanceTypeSpecs
    """
    vcpus: StrictInt = Field(..., description="Number of virtual CPUs")
    memory_gib: StrictInt = Field(..., description="Amount of RAM, in gibibytes (GiB)")
    storage_gib: StrictInt = Field(..., description="Amount of storage, in gibibytes (GiB).")
    __properties = ["vcpus", "memory_gib", "storage_gib"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstanceTypeSpecs:
        """Create an instance of InstanceTypeSpecs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstanceTypeSpecs:
        """Create an instance of InstanceTypeSpecs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstanceTypeSpecs.parse_obj(obj)

        _obj = InstanceTypeSpecs.parse_obj({
            "vcpus": obj.get("vcpus"),
            "memory_gib": obj.get("memory_gib"),
            "storage_gib": obj.get("storage_gib")
        })
        return _obj

