# coding: utf-8

"""
    Lambda Cloud API

    API for interacting with the Lambda GPU Cloud  # noqa: E501

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from lambda_cloud_client.models.instance_type import InstanceType
from lambda_cloud_client.models.region import Region

class InstanceTypes200ResponseDataValue(BaseModel):
    """
    InstanceTypes200ResponseDataValue
    """
    instance_type: InstanceType = Field(...)
    regions_with_capacity_available: conlist(Region) = Field(..., description="List of regions, if any, that have this instance type available")
    __properties = ["instance_type", "regions_with_capacity_available"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstanceTypes200ResponseDataValue:
        """Create an instance of InstanceTypes200ResponseDataValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of instance_type
        if self.instance_type:
            _dict['instance_type'] = self.instance_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in regions_with_capacity_available (list)
        _items = []
        if self.regions_with_capacity_available:
            for _item in self.regions_with_capacity_available:
                if _item:
                    _items.append(_item.to_dict())
            _dict['regions_with_capacity_available'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstanceTypes200ResponseDataValue:
        """Create an instance of InstanceTypes200ResponseDataValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstanceTypes200ResponseDataValue.parse_obj(obj)

        _obj = InstanceTypes200ResponseDataValue.parse_obj({
            "instance_type": InstanceType.from_dict(obj.get("instance_type")) if obj.get("instance_type") is not None else None,
            "regions_with_capacity_available": [Region.from_dict(_item) for _item in obj.get("regions_with_capacity_available")] if obj.get("regions_with_capacity_available") is not None else None
        })
        return _obj

