# coding: utf-8

"""
    Lambda Cloud API

    API for interacting with the Lambda GPU Cloud  # noqa: E501

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr

class SshKey(BaseModel):
    """
    Information about a stored SSH key, which can be used to access instances over SSH
    """
    id: StrictStr = Field(..., description="Unique identifier (ID) of an SSH key")
    name: constr(strict=True, max_length=64) = Field(..., description="Name of the SSH key")
    public_key: constr(strict=True, max_length=4096) = Field(..., description="Public key for the SSH key")
    private_key: Optional[StrictStr] = Field(None, description="Private key for the SSH key. Only returned when generating a new key pair.")
    __properties = ["id", "name", "public_key", "private_key"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SshKey:
        """Create an instance of SshKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if private_key (nullable) is None
        # and __fields_set__ contains the field
        if self.private_key is None and "private_key" in self.__fields_set__:
            _dict['private_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SshKey:
        """Create an instance of SshKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SshKey.parse_obj(obj)

        _obj = SshKey.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "public_key": obj.get("public_key"),
            "private_key": obj.get("private_key")
        })
        return _obj

