import * as cdk from 'aws-cdk-lib';
import * as events from 'aws-cdk-lib/aws-events';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
/**
 * Properties for `LambdaLayerVersionCleaner`
 */
export interface ILambdaLayerVersionCleanerProps {
    /**
     * Number of versions to retain (no default value, must be a positive integer)
     */
    retainVersions: number;
    /**
     * Schedule for the function execution (no default value)
     */
    layerCleanerSchedule: events.Schedule;
    /**
     * Maximum allowed runtime for the Lambda function (default is 15 minutes)
     * @default cdk.Duration.minutes(15)
     */
    handlerTimeout?: cdk.Duration;
    /**
     * Amount of memory allocated to the Lambda function (default is 256MB)
     * @default 256
     */
    handlerMemorySize?: number;
}
/**
 * Lambda Layer Version Cleaner Construct
 *
 * This construct creates a Lambda function that deletes old versions of a Lambda Layer. The function is
 * scheduled to run at a regular interval using an EventBridge rule. The number of versions to retain
 * must be specified as a positive integer using the `ILambdaLayerVersionCleanerProps` interface.
 * The function execution schedule is also required to be set in the `ILambdaLayerVersionCleanerProps` interface.
 */
export declare class LambdaLayerVersionCleaner extends Construct {
    readonly handler: lambda.Function;
    readonly rule: events.Rule;
    constructor(scope: Construct, id: string, props: ILambdaLayerVersionCleanerProps);
}
