"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaLayerVersionCleaner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const delete_old_lambda_layer_versions_function_1 = require("./lambda/delete-old-lambda-layer-versions-function");
/**
 * Lambda Layer Version Cleaner Construct
 *
 * This construct creates a Lambda function that deletes old versions of a Lambda Layer. The function is
 * scheduled to run at a regular interval using an EventBridge rule. The number of versions to retain, as
 * well as the function execution schedule, can be customized using the `ILambdaLayerVersionCleanerProps`
 * interface.
 */
class LambdaLayerVersionCleaner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Create the Lambda function to delete old layer versions
        this.handler = new delete_old_lambda_layer_versions_function_1.DeleteOldLambdaLayerVersionsFunction(this, 'DeleteOldLambdaLayerVersionsFunction', {
            environment: { RETAIN_VERSIONS: props?.retainVersions ?? '10' },
            timeout: props?.handlerTimeout ?? cdk.Duration.minutes(15),
            memorySize: props?.handlerMemorySize ?? 256,
        });
        // Create the LogGroup for the Lambda function
        new logs.LogGroup(this, `${this.handler.node.id}LogGroup`, {
            logGroupName: `/aws/lambda/${this.handler.functionName}`,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
        // Add the necessary IAM permissions for the Lambda function
        const handlerPolicyStatement = new iam.PolicyStatement({
            actions: ['lambda:ListLayers', 'lambda:ListLayerVersions', 'lambda:DeleteLayerVersion'],
            effect: iam.Effect.ALLOW,
            resources: ['*'],
        });
        this.handler.addToRolePolicy(handlerPolicyStatement);
        // Create the EventBridge rule for the Lambda function execution schedule
        this.rule = new events.Rule(this, 'LayerCleanerScheduleRule', {
            schedule: props?.layerCleanerSchedule ?? events.Schedule.rate(cdk.Duration.days(1)),
        });
        this.rule.addTarget(new targets.LambdaFunction(this.handler));
        // Add the necessary permissions for the EventBridge rule to invoke the Lambda function
        targets.addLambdaPermission(this.rule, this.handler);
    }
}
exports.LambdaLayerVersionCleaner = LambdaLayerVersionCleaner;
_a = JSII_RTTI_SYMBOL_1;
LambdaLayerVersionCleaner[_a] = { fqn: "lambda-layer-version-cleaner.LambdaLayerVersionCleaner", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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