from __future__ import annotations
import dataclasses
import requests as requests_http
from ..shared import ssh_key as shared_ssh_key
from typing import Optional


@dataclasses.dataclass
class GetProjectSSHKeysSecurity:
    bearer: str = dataclasses.field(metadata={'security': { 'scheme': True, 'type': 'apiKey', 'sub_type': 'header', 'field_name': 'Authorization' }})
    

@dataclasses.dataclass
class GetProjectSSHKeysPathParams:
    project_id_or_slug: str = dataclasses.field(metadata={'path_param': { 'field_name': 'project_id_or_slug', 'style': 'simple', 'explode': False }})
    

@dataclasses.dataclass
class GetProjectSSHKeysQueryParams:
    include: Optional[str] = dataclasses.field(default=None, metadata={'query_param': { 'field_name': 'include', 'style': 'form', 'explode': True }})
    

@dataclasses.dataclass
class GetProjectSSHKeysRequest:
    path_params: GetProjectSSHKeysPathParams = dataclasses.field()
    query_params: GetProjectSSHKeysQueryParams = dataclasses.field()
    

@dataclasses.dataclass
class GetProjectSSHKeysResponse:
    content_type: str = dataclasses.field()
    status_code: int = dataclasses.field()
    raw_response: Optional[requests_http.Response] = dataclasses.field(default=None)
    ssh_key: Optional[shared_ssh_key.SSHKey] = dataclasses.field(default=None)
    