import requests as requests_http
from . import utils
from .account import Account
from .api_keys import APIKeys
from .api_version import APIVersion
from .bandwidth import Bandwidth
from .bandwidth_packages import BandwidthPackages
from .deploy_config import DeployConfig
from .ip_addresses import IPAddresses
from .ipmi_credentials import IPMICredentials
from .members import Members
from .operating_systems import OperatingSystems
from .plans import Plans
from .power_actions import PowerActions
from .projects import Projects
from .regions import Regions
from .rescue_mode import RescueMode
from .roles import Roles
from .server_reinstall import ServerReinstall
from .servers import Servers
from .ssh_keys import SSHKeys
from .teams import Teams
from .user_data import UserData
from .virtual_network_assignments import VirtualNetworkAssignments
from .virtual_networks import VirtualNetworks
from .vpn_sessions import VPNSessions

SERVERS = [
	"https://api.latitude.sh",
]

class Latitude:
    api_keys: APIKeys
    api_version: APIVersion
    account: Account
    bandwidth: Bandwidth
    bandwidth_packages: BandwidthPackages
    deploy_config: DeployConfig
    ip_addresses: IPAddresses
    ipmi_credentials: IPMICredentials
    members: Members
    operating_systems: OperatingSystems
    plans: Plans
    power_actions: PowerActions
    projects: Projects
    regions: Regions
    rescue_mode: RescueMode
    roles: Roles
    ssh_keys: SSHKeys
    server_reinstall: ServerReinstall
    servers: Servers
    teams: Teams
    user_data: UserData
    vpn_sessions: VPNSessions
    virtual_network_assignments: VirtualNetworkAssignments
    virtual_networks: VirtualNetworks
    
    _client: requests_http.Session
    _security_client: requests_http.Session
    
    _server_url: str = SERVERS[0]
    _language: str = "python"
    _sdk_version: str = "2.6.5"
    _gen_version: str = "1.9.3"

    def __init__(self) -> None:
        self._client = requests_http.Session()
        self._security_client = requests_http.Session()
        self._init_sdks()

    def config_server_url(self, server_url: str, params: dict[str, str] = None):
        if params is not None:
            self._server_url = utils.template_url(server_url, params)
        else:
            self._server_url = server_url

        self._init_sdks()
    
    

    def config_client(self, client: requests_http.Session):
        self._client = client
        self._init_sdks()
    
    
    
    def _init_sdks(self):
        self.api_keys = APIKeys(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.api_version = APIVersion(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.account = Account(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.bandwidth = Bandwidth(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.bandwidth_packages = BandwidthPackages(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.deploy_config = DeployConfig(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.ip_addresses = IPAddresses(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.ipmi_credentials = IPMICredentials(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.members = Members(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.operating_systems = OperatingSystems(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.plans = Plans(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.power_actions = PowerActions(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.projects = Projects(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.regions = Regions(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.rescue_mode = RescueMode(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.roles = Roles(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.ssh_keys = SSHKeys(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.server_reinstall = ServerReinstall(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.servers = Servers(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.teams = Teams(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.user_data = UserData(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.vpn_sessions = VPNSessions(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.virtual_network_assignments = VirtualNetworkAssignments(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
        self.virtual_networks = VirtualNetworks(
            self._client,
            self._security_client,
            self._server_url,
            self._language,
            self._sdk_version,
            self._gen_version
        )
        
    