"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class BillingUsageProjectTypedDict(TypedDict):
    r"""The project in which the returned usage belongs to"""

    id: NotRequired[str]
    slug: NotRequired[str]
    name: NotRequired[str]


class BillingUsageProject(BaseModel):
    r"""The project in which the returned usage belongs to"""

    id: Optional[str] = None

    slug: Optional[str] = None

    name: Optional[str] = None


class PeriodTypedDict(TypedDict):
    r"""The period from the returned billing cycle"""

    start: NotRequired[datetime]
    end: NotRequired[datetime]


class Period(BaseModel):
    r"""The period from the returned billing cycle"""

    start: Optional[datetime] = None

    end: Optional[datetime] = None


class BillingUsageType(str, Enum):
    r"""Type of discount (percentage or fixed amount)"""

    PERCENT = "percent"
    AMOUNT = "amount"


class DiscountsTypedDict(TypedDict):
    description: str
    r"""Description of the discount"""
    type: BillingUsageType
    r"""Type of discount (percentage or fixed amount)"""
    value: float
    r"""Value of the discount (percentage or amount)"""


class Discounts(BaseModel):
    description: str
    r"""Description of the discount"""

    type: BillingUsageType
    r"""Type of discount (percentage or fixed amount)"""

    value: float
    r"""Value of the discount (percentage or amount)"""


class Unit(str, Enum):
    QUANTITY = "quantity"
    HOUR = "hour"
    MINUTE = "minute"


class UsageType(str, Enum):
    LICENSED = "licensed"
    METERED = "metered"


class MetadataTypedDict(TypedDict):
    id: NotRequired[str]
    hostname: NotRequired[str]
    plan: NotRequired[str]
    tags: NotRequired[List[str]]


class Metadata(BaseModel):
    id: Optional[str] = None

    hostname: Optional[str] = None

    plan: Optional[str] = None

    tags: Optional[List[str]] = None


class ProductsTypedDict(TypedDict):
    id: NotRequired[str]
    resource: NotRequired[str]
    name: NotRequired[str]
    proration: NotRequired[bool]
    discounts: NotRequired[List[DiscountsTypedDict]]
    discountable: NotRequired[bool]
    description: NotRequired[str]
    amount_without_discount: NotRequired[int]
    start: NotRequired[datetime]
    end: NotRequired[datetime]
    unit: NotRequired[Unit]
    unit_price: NotRequired[float]
    r"""The unit price of the product in cents"""
    usage_type: NotRequired[UsageType]
    quantity: NotRequired[float]
    price: NotRequired[float]
    r"""The total usage price of the product in cents"""
    metadata: NotRequired[MetadataTypedDict]


class Products(BaseModel):
    id: Optional[str] = None

    resource: Optional[str] = None

    name: Optional[str] = None

    proration: Optional[bool] = None

    discounts: Optional[List[Discounts]] = None

    discountable: Optional[bool] = None

    description: Optional[str] = None

    amount_without_discount: Optional[int] = None

    start: Optional[datetime] = None

    end: Optional[datetime] = None

    unit: Optional[Unit] = None

    unit_price: Optional[float] = None
    r"""The unit price of the product in cents"""

    usage_type: Optional[UsageType] = None

    quantity: Optional[float] = None

    price: Optional[float] = None
    r"""The total usage price of the product in cents"""

    metadata: Optional[Metadata] = None


class BillingUsageAttributesTypedDict(TypedDict):
    project: NotRequired[BillingUsageProjectTypedDict]
    r"""The project in which the returned usage belongs to"""
    period: NotRequired[PeriodTypedDict]
    r"""The period from the returned billing cycle"""
    price: NotRequired[float]
    r"""The total usage price in cents"""
    threshold: NotRequired[float]
    r"""The threshold which we use to charge your usage, in cents"""
    products: NotRequired[List[ProductsTypedDict]]
    available_credit_balance: NotRequired[int]
    r"""The available credit balance in cents"""


class BillingUsageAttributes(BaseModel):
    project: Optional[BillingUsageProject] = None
    r"""The project in which the returned usage belongs to"""

    period: Optional[Period] = None
    r"""The period from the returned billing cycle"""

    price: Optional[float] = None
    r"""The total usage price in cents"""

    threshold: Optional[float] = None
    r"""The threshold which we use to charge your usage, in cents"""

    products: Optional[List[Products]] = None

    available_credit_balance: Optional[int] = None
    r"""The available credit balance in cents"""


class BillingUsageDataTypedDict(TypedDict):
    id: NotRequired[str]
    attributes: NotRequired[BillingUsageAttributesTypedDict]


class BillingUsageData(BaseModel):
    id: Optional[str] = None

    attributes: Optional[BillingUsageAttributes] = None


class BillingUsageTypedDict(TypedDict):
    data: NotRequired[BillingUsageDataTypedDict]


class BillingUsage(BaseModel):
    data: Optional[BillingUsageData] = None
