"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ContainerPlanDataType(str, Enum):
    CONTAINER_PLAN = "container_plan"


class ContainerPlanDataCPUTypedDict(TypedDict):
    cores: NotRequired[float]
    count: NotRequired[float]


class ContainerPlanDataCPU(BaseModel):
    cores: Optional[float] = None

    count: Optional[float] = None


class ContainerPlanDataMemoryTypedDict(TypedDict):
    total: NotRequired[float]


class ContainerPlanDataMemory(BaseModel):
    total: Optional[float] = None


class EphemeralStorageTypedDict(TypedDict):
    size: NotRequired[float]


class EphemeralStorage(BaseModel):
    size: Optional[float] = None


class ContainerPlanDataGpuTypedDict(TypedDict):
    count: NotRequired[float]
    type: NotRequired[str]


class ContainerPlanDataGpu(BaseModel):
    count: Optional[float] = None

    type: Optional[str] = None


class ContainerPlanDataSpecsTypedDict(TypedDict):
    cpu: NotRequired[ContainerPlanDataCPUTypedDict]
    memory: NotRequired[ContainerPlanDataMemoryTypedDict]
    ephemeral_storage: NotRequired[EphemeralStorageTypedDict]
    gpu: NotRequired[ContainerPlanDataGpuTypedDict]


class ContainerPlanDataSpecs(BaseModel):
    cpu: Optional[ContainerPlanDataCPU] = None

    memory: Optional[ContainerPlanDataMemory] = None

    ephemeral_storage: Optional[EphemeralStorage] = None

    gpu: Optional[ContainerPlanDataGpu] = None


class ContainerPlanDataLocationsTypedDict(TypedDict):
    available: NotRequired[List[str]]
    in_stock: NotRequired[List[str]]


class ContainerPlanDataLocations(BaseModel):
    available: Optional[List[str]] = None

    in_stock: Optional[List[str]] = None


class ContainerPlanDataStockLevel(str, Enum):
    UNAVAILABLE = "unavailable"
    LOW = "low"
    MEDIUM = "medium"
    HIGH = "high"


class ContainerPlanDataUSDTypedDict(TypedDict):
    minute: NotRequired[float]
    hour: NotRequired[float]


class ContainerPlanDataUSD(BaseModel):
    minute: Optional[float] = None

    hour: Optional[float] = None


class ContainerPlanDataBRLTypedDict(TypedDict):
    minute: NotRequired[float]
    hour: NotRequired[float]


class ContainerPlanDataBRL(BaseModel):
    minute: Optional[float] = None

    hour: Optional[float] = None


class ContainerPlanDataPricingTypedDict(TypedDict):
    usd: NotRequired[ContainerPlanDataUSDTypedDict]
    brl: NotRequired[ContainerPlanDataBRLTypedDict]


class ContainerPlanDataPricing(BaseModel):
    usd: Annotated[Optional[ContainerPlanDataUSD], pydantic.Field(alias="USD")] = None

    brl: Annotated[Optional[ContainerPlanDataBRL], pydantic.Field(alias="BRL")] = None


class ContainerPlanDataRegionsTypedDict(TypedDict):
    name: NotRequired[str]
    locations: NotRequired[ContainerPlanDataLocationsTypedDict]
    stock_level: NotRequired[ContainerPlanDataStockLevel]
    pricing: NotRequired[ContainerPlanDataPricingTypedDict]


class ContainerPlanDataRegions(BaseModel):
    name: Optional[str] = None

    locations: Optional[ContainerPlanDataLocations] = None

    stock_level: Optional[ContainerPlanDataStockLevel] = None

    pricing: Optional[ContainerPlanDataPricing] = None


class ContainerPlanDataAttributesTypedDict(TypedDict):
    slug: NotRequired[str]
    specs: NotRequired[ContainerPlanDataSpecsTypedDict]
    regions: NotRequired[List[ContainerPlanDataRegionsTypedDict]]


class ContainerPlanDataAttributes(BaseModel):
    slug: Optional[str] = None

    specs: Optional[ContainerPlanDataSpecs] = None

    regions: Optional[List[ContainerPlanDataRegions]] = None


class ContainerPlanDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[ContainerPlanDataType]
    attributes: NotRequired[ContainerPlanDataAttributesTypedDict]


class ContainerPlanData(BaseModel):
    id: Optional[str] = None

    type: Optional[ContainerPlanDataType] = None

    attributes: Optional[ContainerPlanDataAttributes] = None
