"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateFirewallFirewallsType(str, Enum):
    FIREWALLS = "firewalls"


class CreateFirewallProtocol(str, Enum):
    TCP = "TCP"
    UDP = "UDP"


class CreateFirewallRulesTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Source IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""
    to: NotRequired[str]
    r"""Destination IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""
    protocol: NotRequired[CreateFirewallProtocol]
    port: NotRequired[str]
    r"""Port number or range (e.g., \"80\", \"80-443\")"""


class CreateFirewallRules(BaseModel):
    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None
    r"""Source IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""

    to: Optional[str] = None
    r"""Destination IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""

    protocol: Optional[CreateFirewallProtocol] = None

    port: Optional[str] = None
    r"""Port number or range (e.g., \"80\", \"80-443\")"""


class CreateFirewallFirewallsAttributesTypedDict(TypedDict):
    name: str
    project: str
    rules: NotRequired[List[CreateFirewallRulesTypedDict]]


class CreateFirewallFirewallsAttributes(BaseModel):
    name: str

    project: str

    rules: Optional[List[CreateFirewallRules]] = None


class CreateFirewallFirewallsDataTypedDict(TypedDict):
    type: CreateFirewallFirewallsType
    attributes: NotRequired[CreateFirewallFirewallsAttributesTypedDict]


class CreateFirewallFirewallsData(BaseModel):
    type: CreateFirewallFirewallsType

    attributes: Optional[CreateFirewallFirewallsAttributes] = None


class CreateFirewallFirewallsRequestBodyTypedDict(TypedDict):
    data: CreateFirewallFirewallsDataTypedDict


class CreateFirewallFirewallsRequestBody(BaseModel):
    data: CreateFirewallFirewallsData
