"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CreateServerServersType(str, Enum):
    SERVERS = "servers"


class CreateServerServersPlan(str, Enum):
    r"""The plan slug to choose server from, defining the specs the server will have"""

    C2_LARGE_X86 = "c2-large-x86"
    C2_MEDIUM_X86 = "c2-medium-x86"
    C2_SMALL_X86 = "c2-small-x86"
    C3_LARGE_X86 = "c3-large-x86"
    C3_MEDIUM_X86 = "c3-medium-x86"
    C3_SMALL_X86 = "c3-small-x86"
    C3_XLARGE_X86 = "c3-xlarge-x86"
    G3_LARGE_X86 = "g3-large-x86"
    G3_MEDIUM_X86 = "g3-medium-x86"
    G3_SMALL_X86 = "g3-small-x86"
    G3_XLARGE_X86 = "g3-xlarge-x86"
    M3_LARGE_X86 = "m3-large-x86"
    S2_SMALL_X86 = "s2-small-x86"
    S3_LARGE_X86 = "s3-large-x86"


class CreateServerServersSite(str, Enum):
    r"""The site slug to deploy the server (case-insensitive)"""

    ASH = "ASH"
    BGT = "BGT"
    BUE = "BUE"
    CHI = "CHI"
    DAL = "DAL"
    FRA = "FRA"
    LAX = "LAX"
    LON = "LON"
    MEX = "MEX"
    MEX2 = "MEX2"
    MIA = "MIA"
    MIA2 = "MIA2"
    NYC = "NYC"
    SAN = "SAN"
    SAO = "SAO"
    SAO2 = "SAO2"
    SYD = "SYD"
    TYO = "TYO"
    TYO2 = "TYO2"


class CreateServerServersOperatingSystem(str, Enum):
    r"""The operating system slug for the new server"""

    IPXE = "ipxe"
    WINDOWS_SERVER_2019_STD_V1 = "windows_server_2019_std_v1"
    UBUNTU_22_04_X64_LTS = "ubuntu_22_04_x64_lts"
    DEBIAN_11 = "debian_11"
    DEBIAN_10 = "debian_10"
    RHEL8 = "rhel8"
    WINDOWS_SERVER_2012_R2_STD_V28 = "windows_server_2012_r2_std_v28"
    WINDOWS_SERVER_2012_R2_DC_V5 = "windows_server_2012_r2_dc_v5"
    ESXI_6_7 = "esxi_6_7"
    DEBIAN_9_4_X64 = "debian_9_4_x64"
    CENTOS_7_4_X64 = "centos_7_4_x64"
    CENTOS_8_X64 = "centos_8_x64"
    UBUNTU_16_04_X64_LTS = "ubuntu_16_04_x64_lts"
    UBUNTU_20_04_X64_LTS = "ubuntu_20_04_x64_lts"
    WINDOWS_SERVER_2016_STD_V1 = "windows_server_2016_std_v1"
    WINDOWS_SERVER_2016_DC_V1 = "windows_server_2016_dc_v1"
    WINDOWS_SERVER_2019_DC_V1 = "windows_server_2019_dc_v1"
    DEBIAN_12 = "debian_12"
    UBUNTU22_ML_IN_A_BOX = "ubuntu22_ml_in_a_box"
    UBUNTU_18_04_X64_LTS = "ubuntu_18_04_x64_lts"
    WINDOWS_SERVER_2019_STD_UEFI = "windows_server_2019_std_uefi"
    WINDOWS_2022_STD_UEFI = "windows_2022_std_uefi"
    WINDOWS_2022_STD = "windows_2022_std"
    UBUNTU_24_04_X64_LTS = "ubuntu_24_04_x64_lts"
    ROCKYLINUX_8 = "rockylinux_8"


class CreateServerRaid(str, Enum):
    r"""RAID mode for the server"""

    RAID_0 = "raid-0"
    RAID_1 = "raid-1"


class CreateServerServersBilling(str, Enum):
    r"""The server billing type. Accepts `hourly` and `monthly` for on demand projects and `yearly` for reserved projects."""

    HOURLY = "hourly"
    MONTHLY = "monthly"
    YEARLY = "yearly"


class CreateServerServersAttributesTypedDict(TypedDict):
    project: NotRequired[str]
    r"""The project (ID or Slug) to deploy the server"""
    plan: NotRequired[CreateServerServersPlan]
    r"""The plan slug to choose server from, defining the specs the server will have"""
    site: NotRequired[CreateServerServersSite]
    r"""The site slug to deploy the server (case-insensitive)"""
    operating_system: NotRequired[CreateServerServersOperatingSystem]
    r"""The operating system slug for the new server"""
    hostname: NotRequired[str]
    r"""The server hostname"""
    ssh_keys: NotRequired[List[str]]
    r"""SSH Keys to set on the server"""
    user_data: NotRequired[str]
    r"""User data ID to set on the server. This is a custom script that will run after the deploy"""
    raid: NotRequired[CreateServerRaid]
    r"""RAID mode for the server"""
    ipxe: NotRequired[str]
    r"""URL where iPXE script is stored on, OR the iPXE script encoded in base64. This attribute is required when iPXE is selected as operating system."""
    billing: NotRequired[CreateServerServersBilling]
    r"""The server billing type. Accepts `hourly` and `monthly` for on demand projects and `yearly` for reserved projects."""


class CreateServerServersAttributes(BaseModel):
    project: Optional[str] = None
    r"""The project (ID or Slug) to deploy the server"""

    plan: Optional[CreateServerServersPlan] = None
    r"""The plan slug to choose server from, defining the specs the server will have"""

    site: Optional[CreateServerServersSite] = None
    r"""The site slug to deploy the server (case-insensitive)"""

    operating_system: Optional[CreateServerServersOperatingSystem] = None
    r"""The operating system slug for the new server"""

    hostname: Optional[str] = None
    r"""The server hostname"""

    ssh_keys: Optional[List[str]] = None
    r"""SSH Keys to set on the server"""

    user_data: Optional[str] = None
    r"""User data ID to set on the server. This is a custom script that will run after the deploy"""

    raid: Optional[CreateServerRaid] = None
    r"""RAID mode for the server"""

    ipxe: Optional[str] = None
    r"""URL where iPXE script is stored on, OR the iPXE script encoded in base64. This attribute is required when iPXE is selected as operating system."""

    billing: Optional[CreateServerServersBilling] = None
    r"""The server billing type. Accepts `hourly` and `monthly` for on demand projects and `yearly` for reserved projects."""


class CreateServerServersDataTypedDict(TypedDict):
    type: CreateServerServersType
    attributes: NotRequired[CreateServerServersAttributesTypedDict]


class CreateServerServersData(BaseModel):
    type: CreateServerServersType

    attributes: Optional[CreateServerServersAttributes] = None


class CreateServerServersRequestBodyTypedDict(TypedDict):
    data: NotRequired[CreateServerServersDataTypedDict]


class CreateServerServersRequestBody(BaseModel):
    data: Optional[CreateServerServersData] = None
