"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from latitudesh_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FirewallDataType(str, Enum):
    FIREWALLS = "firewalls"


class RulesTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Source IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""
    to: NotRequired[str]
    r"""Destination IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""
    port: NotRequired[str]
    protocol: NotRequired[str]


class Rules(BaseModel):
    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None
    r"""Source IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""

    to: Optional[str] = None
    r"""Destination IP address, IP range in CIDR notation, or 'ANY' (e.g., \"192.168.1.1\", \"192.168.1.0/24\", \"ANY\")"""

    port: Optional[str] = None

    protocol: Optional[str] = None


class FirewallDataProjectTypedDict(TypedDict):
    id: NotRequired[str]
    slug: NotRequired[str]
    name: NotRequired[str]


class FirewallDataProject(BaseModel):
    id: Optional[str] = None

    slug: Optional[str] = None

    name: Optional[str] = None


class FirewallDataAttributesTypedDict(TypedDict):
    name: NotRequired[str]
    rules: NotRequired[List[RulesTypedDict]]
    project: NotRequired[FirewallDataProjectTypedDict]


class FirewallDataAttributes(BaseModel):
    name: Optional[str] = None

    rules: Optional[List[Rules]] = None

    project: Optional[FirewallDataProject] = None


class FirewallDataTypedDict(TypedDict):
    id: NotRequired[str]
    type: NotRequired[FirewallDataType]
    attributes: NotRequired[FirewallDataAttributesTypedDict]


class FirewallData(BaseModel):
    id: Optional[str] = None

    type: Optional[FirewallDataType] = None

    attributes: Optional[FirewallDataAttributes] = None
