"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .firewall_assignments import FirewallAssignments, FirewallAssignmentsTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetAllFirewallAssignmentsRequestTypedDict(TypedDict):
    filter_server: NotRequired[str]
    r"""The server ID to filter by"""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetAllFirewallAssignmentsRequest(BaseModel):
    filter_server: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[server]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The server ID to filter by"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetAllFirewallAssignmentsResponseTypedDict(TypedDict):
    result: FirewallAssignmentsTypedDict


class GetAllFirewallAssignmentsResponse(BaseModel):
    next: Callable[[], Optional[GetAllFirewallAssignmentsResponse]]

    result: FirewallAssignments
