"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bandwidth_plans import BandwidthPlans, BandwidthPlansTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetBandwidthPlansRequestTypedDict(TypedDict):
    api_version: NotRequired[str]
    filter_id: NotRequired[str]
    r"""The plan ID to filter by"""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetBandwidthPlansRequest(BaseModel):
    api_version: Annotated[
        Optional[str],
        pydantic.Field(alias="API-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "2023-06-01"

    filter_id: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[id]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The plan ID to filter by"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetBandwidthPlansResponseTypedDict(TypedDict):
    result: BandwidthPlansTypedDict


class GetBandwidthPlansResponse(BaseModel):
    next: Callable[[], Optional[GetBandwidthPlansResponse]]

    result: BandwidthPlans
