"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetBillingUsageRequestTypedDict(TypedDict):
    filter_project: str
    filter_products: NotRequired[List[str]]
    r"""Allows to filter the billing usage for specific products. It accepts an array of product ids.

    """
    filter_plan: NotRequired[str]
    r"""Accepts a plan name and allows to filter the usage for that plan.

    """


class GetBillingUsageRequest(BaseModel):
    filter_project: Annotated[
        str,
        pydantic.Field(alias="filter[project]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    filter_products: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="filter[products][]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Allows to filter the billing usage for specific products. It accepts an array of product ids.

    """

    filter_plan: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[plan]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Accepts a plan name and allows to filter the usage for that plan.

    """
