"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .events import Events, EventsTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetEventsRequestTypedDict(TypedDict):
    filter_author: NotRequired[str]
    r"""The author ID or email to filter by"""
    filter_project: NotRequired[str]
    r"""The project ID to filter by"""
    filter_target_name: NotRequired[List[str]]
    r"""The target type(s) of the event to filter by"""
    filter_target_id: NotRequired[str]
    r"""The target id of the event to filter by"""
    filter_action: NotRequired[str]
    r"""The action performed in event to filter by"""
    filter_created_at_gte: NotRequired[str]
    r"""The created at greater than equal date to filter by, in ISO formatting (yyyy-MM-dd'T'HH:mm:ss)"""
    filter_created_at_lte: NotRequired[str]
    r"""The created at less than equal date to filter by, in ISO formatting (yyyy-MM-dd'T'HH:mm:ss)"""
    filter_created_at: NotRequired[List[str]]
    r"""The created at between date range date1, date2 (inclusive) to filter by, in ISO formatting (yyyy-MM-dd'T'HH:mm:ss)"""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetEventsRequest(BaseModel):
    filter_author: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[author]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The author ID or email to filter by"""

    filter_project: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[project]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The project ID to filter by"""

    filter_target_name: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="filter[target_name]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The target type(s) of the event to filter by"""

    filter_target_id: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[target_id]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The target id of the event to filter by"""

    filter_action: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[action]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The action performed in event to filter by"""

    filter_created_at_gte: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[created_at][gte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The created at greater than equal date to filter by, in ISO formatting (yyyy-MM-dd'T'HH:mm:ss)"""

    filter_created_at_lte: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[created_at][lte]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The created at less than equal date to filter by, in ISO formatting (yyyy-MM-dd'T'HH:mm:ss)"""

    filter_created_at: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="filter[created_at]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The created at between date range date1, date2 (inclusive) to filter by, in ISO formatting (yyyy-MM-dd'T'HH:mm:ss)"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetEventsResponseBodyTypedDict(TypedDict):
    r"""Success"""

    data: NotRequired[List[EventsTypedDict]]


class GetEventsResponseBody(BaseModel):
    r"""Success"""

    data: Optional[List[Events]] = None


class GetEventsResponseTypedDict(TypedDict):
    result: GetEventsResponseBodyTypedDict


class GetEventsResponse(BaseModel):
    next: Callable[[], Optional[GetEventsResponse]]

    result: GetEventsResponseBody
