"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .firewall_assignments import FirewallAssignments, FirewallAssignmentsTypedDict
from latitudesh_python_sdk.types import BaseModel
from latitudesh_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetFirewallAssignmentsRequestTypedDict(TypedDict):
    firewall_id: str
    r"""The Firewall ID"""
    page_size: NotRequired[int]
    r"""Number of items to return per page"""
    page_number: NotRequired[int]
    r"""Page number to return (starts at 1)"""


class GetFirewallAssignmentsRequest(BaseModel):
    firewall_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The Firewall ID"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""Number of items to return per page"""

    page_number: Annotated[
        Optional[int],
        pydantic.Field(alias="page[number]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number to return (starts at 1)"""


class GetFirewallAssignmentsResponseTypedDict(TypedDict):
    result: FirewallAssignmentsTypedDict


class GetFirewallAssignmentsResponse(BaseModel):
    next: Callable[[], Optional[GetFirewallAssignmentsResponse]]

    result: FirewallAssignments
